
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adgetstr.adb "adatui-get_strings.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate(AdaTui)
procedure get_strings (
   items : in out input_items;
   field : in     integer;
   key   :    out integer )
is
   winput     : pdcurses.A_WINDOW_T;
   old_y      : c.signed_int;
   old_x      : c.signed_int;
   max_y      : c.signed_int;
   max_x      : c.signed_int;
   mid_y      : integer;
   mid_x      : integer;
   num_lines  : integer;
   num_cols   : integer;
   num_fields : integer := 0;
   index      : integer;
   length     : integer;
   row        : integer := 0;
   max_length : integer := 0;
   stop       : boolean := FALSE;
   temp_charv : aliased c.charv(1..80);
   temp_charp : c.charp;
   temp_int   : c.signed_int;
   void       : c.signed_int;
   count      : interfaces.c.size_t;

begin
   for index in items'range loop
      num_fields := num_fields + 1;
      length := bstrings.length ( items(index).description );
      if length > max_length then
	 max_length := length;
      end if;
   end loop;

   num_lines := num_fields + 2;
   num_cols  := max_length + field + 4;
   pdcurses.getyx    ( body_window, old_y, old_x );
   pdcurses.getmaxyx ( body_window, max_y, max_x );
   mid_y := ( integer ( max_y ) - num_lines ) / 2;
   mid_x := ( integer ( max_x ) - num_cols  ) / 2;
   winput := win_move_input_box (
      win   => body_window,
      y     => mid_y,
      x     => mid_x,
      lines => num_lines,
      cols  => num_cols );

   for index in items'range loop
      interfaces.c.to_c (
	 item   => bstrings.to_string ( items(index).description ),
	 target => temp_charv,
	 count  => count );
   --
   -- using unchecked access because type c.charp is defined at a higher
   -- level than temp_charv - creates a potential for dangling pointers
   --
      temp_charp := temp_charv'unchecked_access;
      
      temp_int := c.signed_int ( row + 1 );
      void := pdcurses.mvwprintw ( winput, temp_int, 2, temp_charp );
      row := row + 1;
   end loop;

   index := items'first;
   row := 0;

   while not stop loop
      move_win_edit_string (
	 window => winput,
	 y      => row + 1,
	 x      => max_length + 3,
	 buffer => items(index).buffer,
	 field  => field,
	 key    => key );

      case key is
	 when KEY_ESC =>
	    stop := TRUE;

	 when pdcurses.KEY_UP | KEY_UP =>
	    row := ( row + num_fields - 1 ) rem num_fields;
	    index := items'first + row;

	 when NEWLINE | TAB | pdcurses.KEY_DOWN | KEY_DOWN =>
	    row := row + 1;
	    index := items'first + row;
	    if row = num_fields then
	       stop := TRUE;	 
	    end if;
	 
	 when others =>
	    null;   
      end case;
   end loop;

   void := pdcurses.delwin   ( winput );
   void := pdcurses.touchwin ( body_window  );
   void := pdcurses.wmove    ( body_window, old_y, old_x );
   void := pdcurses.wrefresh ( body_window  );
   return;
end get_strings;
