
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: admaimen.adb "adatui-main_menu.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure main_menu ( mp : a_menu_t ) is
   nitems     : aliased integer;
   barlen     : aliased integer;
   old        : integer := -1;
   cur        : integer :=  0;
   char       : integer;
   cur0       : integer;
   void       : c.signed_int;
   temp_str   : bstrings.bounded_string;
   temp_str2  : bstrings.bounded_string;
   temp_charv : aliased c.charv(1..80);
   temp_charp : c.charp;

begin
   menu_dimension (
      a_menu  => mp,
      lines   => nitems'access,
      cols    => barlen'access);

   repaint_main_menu (
      width  => barlen,
      a_menu => mp );

   while not quit loop
      if cur /= old then
	 if old /= -1 then
	    temp_str2 := pad_string (
	       str    => mp.all(old).item_name.all,
	       length => barlen - 1 );

	    temp_str := prepad_string ( 
	       str    => bstrings.to_string ( temp_str2 ),
	       length => 1 );

	    make_charv (
	       source => temp_str,
	       target => temp_charv );
         --
         -- using unchecked access because type c.charp is defined at a higher
         -- level than temp_charv - creates a potential for dangling pointers
         --
	    temp_charp := temp_charv'unchecked_access;
		  
	    void := pdcurses.mvwaddstr (
	       w   => main_window,
	       y   => 0,
	       x   => c.signed_int ( old * barlen ),
	       str => temp_charp );

	    status_message ( msg => mp.all(cur).item_desc.all );

	 else
	    main_help;
	 end if;

	 set_color (
	    window => main_window,
	    color  => MAINMENUREVCOLOR );

	 temp_str2 := pad_string (
	    str    => mp.all(cur).item_name.all,
	    length => barlen - 1 );

	 temp_str := prepad_string ( 
	    str    => bstrings.to_string ( temp_str2 ),
	    length => 1 );
		  
	 make_charv (
	    source => temp_str,
	    target => temp_charv );
	    
      --
      -- using unchecked access because type c.charp is defined at a higher
      -- level than temp_charv - creates a potential for dangling pointers
      --
	 temp_charp := temp_charv'unchecked_access;

	 void := pdcurses.mvwaddstr (
	    w   => main_window,
	    y   => 0,
	    x   => c.signed_int ( cur * barlen ),
	    str => temp_charp );

	 set_color (
	    window => main_window,
	    color  => MAINMENUCOLOR );

	 old := cur;
	 void := pdcurses.wrefresh (main_window);
      end if;

      if key /= pdcurses.ERR then
	 char := key;
      else
	 char := wait_for_key;
      end if; 

      case char is
	 when pdcurses.KEY_DOWN | KEY_DOWN | NEWLINE |
                                PADENTER | pdcurses.PADENTER => 
	    void := pdcurses.touchwin (body_window);
	    void := pdcurses.wrefresh (body_window);
	    rmerror;
	    set_menu_position ( 
	       y => th + mh,
	       x => cur * barlen );

	    normal_cursor;
	    mp.all(cur).item_func.all;
	    hide_cursor;

	    case key is
	       when pdcurses.KEY_LEFT | KEY_LEFT =>
		  cur := (cur + nitems - 1) mod nitems;
		  key := NEWLINE;

	       when pdcurses.KEY_RIGHT | KEY_RIGHT =>
		  cur := (cur + 1) mod nitems;
		  key := NEWLINE;

	       when others =>
		  key := pdcurses.ERR;
	    end case;

	    repaint_main_menu (
	       width  => barlen,
	       a_menu => mp    );

	    old := -1;

	 when pdcurses.KEY_LEFT | KEY_LEFT =>
	    cur := (cur + nitems - 1) mod nitems;

	 when pdcurses.KEY_RIGHT | KEY_RIGHT =>
	    cur := (cur + 1) mod nitems;

	 when KEY_ESC =>
	    main_help;

	 when others =>
	    cur0 := cur;

	    declare
	       A, B : boolean;
	    begin
	       loop
		  cur := (cur + 1) mod nitems;
		  A := ( cur /= cur0 ); 
		  B := ( hotkey ( mp.all(cur).item_name.all ) /= 
		     ( ada.characters.handling.to_upper (
			 character'val(char)) ) );

		  exit when not (A and B);
	       end loop;

	       if not B then 
		  key := NEWLINE;
	       end if;
	    end;
      end case;
   end loop;

   rmerror;
   void := pdcurses.touchwin ( body_window );
   void := pdcurses.wrefresh ( body_window );
end main_menu;
