WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Ada95_Changes IS
------------------------------------------------------------------
--|                                                              
--| This program shows four small changes in Ada 95:
--|                                                              
--| (1) new names for standard packages (e.g., Ada.Text_IO)
--| (2) new standard packages for numeric input/output
--| (3) variables can legally be declared after procedure bodies
--| (4) OUT parameters can be legally used within the procedure
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
--|                                                              
------------------------------------------------------------------
  
  PROCEDURE ShowOutParameter (Result: OUT Integer) IS
  BEGIN
    Result := 2;
    Result := Result + 1;  -- Result on the right is illegal in Ada 83!
  END ShowOutParameter;

  Y: Integer;    -- declaring Y after a procedure body 
                 -- is illegal in Ada 83!

BEGIN -- Ada95_Changes

  ShowOutParameter(Result => Y);
  Ada.Text_IO.Put(Item => "Y's value is now ");
  Ada.Integer_Text_IO.Put(Item => Y, Width => 1);
  Ada.Text_IO.New_Line;

END Ada95_Changes;
