WITH Currency;
WITH Dates;
PACKAGE Employees IS
------------------------------------------------------------------
--| Specification for ADT package to handle Employee records
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------

  -- constant and type definitions

  MaxName: CONSTANT Positive := 30;
  SUBTYPE NameType IS String(1..30);

  SUBTYPE IDType IS Positive RANGE 1111..9999;
  TYPE    GenderType IS (Female, Male);

  TYPE Employee IS PRIVATE;

  -- operations

  -- constructor

  FUNCTION MakeEmployee (ID:        IDType; 
                         Name:      NameType; 
                         Gender:    GenderType; 
                         NumDepend: Natural;
                         Salary:    Currency.Quantity;
                         StartDate: Dates.Date)  RETURN Employee;
  -- Pre: all input parameters are defined
  -- Post: returns a value of type Employee

  -- selectors

  FUNCTION RetrieveID        (OneEmp: Employee) RETURN IDType;
  FUNCTION RetrieveName      (OneEmp: Employee) RETURN NameType;
  FUNCTION RetrieveGender    (OneEmp: Employee) RETURN GenderType;
  FUNCTION RetrieveNumDepend (OneEmp: Employee) RETURN Natural;   
  FUNCTION RetrieveSalary    (OneEmp: Employee) RETURN Currency.Quantity;
  FUNCTION RetrieveDate      (OneEmp: Employee) RETURN Dates.Date;
  -- Pre: OneEmp is defined
  -- Post: each selector retrieves its desired field

PRIVATE

  TYPE Employee IS RECORD
    ID:        IDType := IDType'Last;
    Name:      NameType := (OTHERS => ' ');
    Gender:    GenderType := Female;
    NumDepend: Natural := 0;
    Salary:    Currency.Quantity := Currency.MakeCurrency(0.00);
    StartDate: Dates.Date := Dates.MakeDate(1980, 1, 1);
  END RECORD;

END Employees;
