FUNCTION Hash_Division_Integer_2
  (K: String; Capacity: Positive) RETURN Natural IS
------------------------------------------------------------------------
--| Division_Integer Hash Function
--| Assumes K is a numeric string; 
--| pretends Integer'Value did not exist.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: February 1996                                     
------------------------------------------------------------------------

  Result: Natural := 0;
  Zero_pos : Natural := Character'Pos('0');

BEGIN -- Hash_Division_Integer_2

  FOR Count IN K'Range LOOP
    Result := 10 * Result + (Character'Pos(K(Count)) - Zero_pos);
  END LOOP;

  RETURN Result REM Capacity;

END Hash_Division_Integer_2;
