FUNCTION Hash_Division_Letter_2 
  (K: String; Capacity: Positive) RETURN Natural IS
------------------------------------------------------------------------
--| Division_Letter_2 Hash Function
--| Assumes K is a string of lowercase letters; treats key as a base
--| 26 number and converts to decimal.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: February 1996                                     
------------------------------------------------------------------------

  Result: Natural := 0;
  a_pos : Natural := Character'Pos('a');

BEGIN -- Hash_Division_Letter_2

  FOR Count IN K'Range LOOP
    Result := 26 * Result + (Character'Pos(K(Count)) - a_pos);
  END LOOP;

  RETURN Result REM Capacity;

END Hash_Division_Letter_2;
