WITH Swap_Generic;
PACKAGE BODY Heaps_Generic IS
------------------------------------------------------------------------
--| Body of Generic Heaps Package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE Exchange IS NEW Swap_Generic(ValueType => ElementType);
  
  FUNCTION ">="(Left, Right: KeyType) RETURN Boolean IS
  BEGIN
    RETURN NOT (Left < Right);
  END ">=";
  
  PROCEDURE ExtendHeap(List: IN OUT ListType) IS
    
    Top    : CONSTANT Integer := Integer(List'First);
    Child  : Integer;  
    Parent : Integer;
    IChild : IndexType; -- to satisfy type compatibility rules
    IParent: IndexType;
 
  BEGIN -- ExtendHeap

    IF List'First = List'Last THEN -- heap has only one element
      RETURN;
    END IF;
     
    Child := Integer(List'Last);
    Parent := Child / 2;
 
    WHILE (Parent >= Top) LOOP
      IParent := IndexType(Parent);
      IChild := IndexType(Child);

      EXIT WHEN KeyOf(List(IParent)) >= KeyOf(List(IChild));
 
      Exchange(List(IChild),List(IParent));
      Child := Parent;
      Parent:= Parent / 2;
 
    END LOOP;
 
  END ExtendHeap;
 
  PROCEDURE AlmostHeapToHeap(List: IN OUT ListType) IS
    
    Bottom : CONSTANT Integer := Integer(List'Last);
    Parent : Integer;
    Child  : Integer;  
    IParent: IndexType; -- for type compatibility
    IChild : IndexType;
    Placed : Boolean := False;
 
  BEGIN -- AlmostHeapToHeap
 
    IF List'First = List'Last THEN -- only one element
      RETURN;
    END IF;

    Parent := Integer(List'First);
    Child  := Integer(List'First) + 1;

    WHILE (Child <= Bottom) AND NOT Placed LOOP
 
      IChild  := IndexType(Child);
      IParent := IndexType(Parent);

      IF Child+1 <= Bottom THEN     -- Parent has 2 Children 
        IF    KeyOf(List(IParent)) >= KeyOf(List(IChild))
          AND KeyOf(List(IParent)) >= KeyOf(List(IChild + 1)) THEN       
          Placed := True;
 
        ELSIF KeyOf(List(IChild+1)) < KeyOf(List(IndexType(Child))) THEN
          Exchange(List(IParent),List(IChild));
          Parent := Child;   --left Child was larger
          Child := 2 * Parent;
 
        ELSE 
          Exchange(List(IParent),List(IChild+1));
          Parent := Child+1; --right Child was larger
          Child := 2 * Parent;
        END IF;
 
      ELSE                   -- Parent has only one Child
        IF KeyOf(List(IParent)) < KeyOf(List(IChild)) THEN
          Exchange(List(IParent),List(IChild));
        END IF;
 
        Placed := True;
 
      END IF;
 
    END LOOP;
 
  END AlmostHeapToHeap;
 
END Heaps_Generic;
