GENERIC

  TYPE KeyType IS PRIVATE;
  TYPE ElementType IS PRIVATE;
  TYPE IndexType IS RANGE <>;   -- integer subscripts
  TYPE ListType IS ARRAY (IndexType RANGE <>) OF ElementType;
  WITH FUNCTION KeyOf  (Element: ElementType) RETURN KeyType IS <>;
  WITH FUNCTION "<"(Left, Right: KeyType) RETURN Boolean IS <>;

PACKAGE Heaps_Generic IS
------------------------------------------------------------------------
--| Specification for Generic Heaps Package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE ExtendHeap(List: IN OUT ListType); 
  --  Pre:  List(List'First..List'Last-1) is a heap such that 
  --    List(List'First) is the "largest" element.
  --  Post: extends heap by adding List(List'Last) to it.

  PROCEDURE AlmostHeapToHeap(List: IN OUT ListType);
  -- Pre:  List(List'First..List'Last) is an "almost heap",
  --   that is, it would be a heap except that List(List'First) may be
  --   "smaller" than one or both of its children
  -- Post: List(List'First..List'Last) is a heap

END Heaps_Generic;
