WITH Lists_Generic;
GENERIC

  TYPE Element IS PRIVATE;

PACKAGE Queues_Generic_List IS
------------------------------------------------------------------
--| Specification for Generic Queues, Implemented with Linked Lists
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  -- type definition

  TYPE Queue (Capacity: Positive) IS LIMITED PRIVATE;

  -- exported exceptions

  QueueFull  : EXCEPTION;
  QueueEmpty : EXCEPTION;

  -- constructors

  PROCEDURE MakeEmpty (Q : IN OUT Queue);
  -- Pre:    Q is defined
  -- Post:   Q is empty

  PROCEDURE Enqueue (Q : IN OUT Queue; E : IN Element);
  -- Pre:    Q and E are defined
  -- Post:   Q is returned with E as the top Element
  -- Raises: QueueFull if Q already contains Capacity Elements

  PROCEDURE Dequeue (Q : IN OUT Queue);
  -- Pre:    Q is defined
  -- Post:   Q is returned with the top Element discarded
  -- Raises: QueueEmpty if Q contains no Elements

  -- selector

  FUNCTION First (Q : IN Queue) RETURN Element;
  -- Pre:    Q is defined
  -- Post:   The first Element of Q is returned
  -- Raises: QueueEmpty if Q contains no Elements

  -- inquiry operations

  FUNCTION IsEmpty (Q : IN Queue) RETURN Boolean;
  -- Pre:    Q is defined
  -- Post:   returns True if Q is empty, False otherwise

  FUNCTION IsFull  (Q : IN Queue) RETURN Boolean;
  -- Pre:    Q is defined
  -- Post:   returns True if Q is full, False otherwise

PRIVATE

  PACKAGE Lists IS
    NEW Lists_Generic(ElementType => Element);

  TYPE Queue (Capacity: Positive) IS RECORD
    Count : Natural := 0;
    Store : Lists.List;
  END RECORD;

END Queues_Generic_List;
