WITH VStrings; USE VStrings;
WITH Character_Stacks; USE Character_Stacks;
FUNCTION RPN_Priorities (X : VString) RETURN VString IS
-- Pre:  X is defined
-- Post: returns a string containing the RPN_Priorities for X;
--   operator priority and association, but no parentheses,
--   are taken into account. Parentheses are simply skipped.

  C         : Character;
  T         : VString(MaxLength(X)) := X;
  S         : Stack(MaxLength(X));
  Result    : VString(MaxLength(X));  -- empty by default

  FUNCTION Priority (Operator : IN character) RETURN integer IS
  BEGIN
    IF Operator = '+' OR Operator = '-' THEN
	RETURN 1;
    ELSE
	RETURN 2;
    END IF;
  END Priority;

BEGIN

  IF NOT IsEmpty (T) THEN
    LOOP
      C := Head (T);

      CASE C IS
        WHEN 'A' .. 'Z' | 'a' .. 'z' | '0' .. '9' =>
          Result := Result & C;
        WHEN '+' | '-' | '*' | '/' =>
          IF IsEmpty (S) THEN
            Push (S, C);
          ELSIF Priority (Top (S)) < Priority (C) THEN
            Push (S, C);
          ELSE
            LOOP -- clear stack of higher priority operators
              Result := Result & Top (S);
              Pop (S);
              EXIT WHEN IsEmpty (S) 
                OR ELSE Priority (Top (S)) < Priority (C);
            END LOOP;
            Push (S, C);
          END IF;
        WHEN OTHERS =>
	  NULL;              -- skip bad characters
      END CASE;

      T := Tail (T);
      EXIT WHEN IsEmpty (T);
    END LOOP;

    WHILE NOT IsEmpty (S) LOOP
      Result := Result & Top (S);
      Pop (S);
    END LOOP;

    RETURN Result;
  END IF;

END RPN_Priorities;
