WITH Swap_Generic;
PROCEDURE Sort_Shell_Generic(List: IN OUT ListType) IS
------------------------------------------------------------------------
--| Body of generic Shell Sort
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE Exchange IS NEW Swap_Generic(ValueType => ElementType);
  
  NewArrival: ElementType;
  Top:        IndexType := List'First;
  Bottom:     IndexType := List'Last;
  Position:   IndexType;
  Distance:   IndexType;
  IntegerDistance:   Integer;
 
BEGIN

  IntegerDistance := Integer(Bottom/2);
  WHILE IntegerDistance > 0 LOOP

    Distance := IndexType(IntegerDistance);
 
    FOR CurrentBottom IN Top+Distance..Bottom LOOP
      Position := CurrentBottom;
          
      WHILE Position >= Top + Distance
        AND THEN KeyOf(List(Position)) < KeyOf(List(Position-Distance)) LOOP
          
        Exchange(List(Position), List(Position - Distance));
        Position := Position - Distance;
      END LOOP;

    END LOOP;

    IntegerDistance := IntegerDistance / 2;

  END LOOP;

END Sort_Shell_Generic;
