WITH Employees.IO;
WITH Debugging_Support; USE Debugging_Support;
PACKAGE BODY Tables IS
------------------------------------------------------------------
--| Body of the abstract data type for a table of
--| element records, each element containing a key.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------
  
  PROCEDURE InitializeTable (T : IN OUT TableType) IS
  BEGIN -- InitializeTable

    Enter(Subprogram => "InitializeTable");

    T.CurrentSize := 0;

    Leave
      (Subprogram => "InitializeTable", Message => "table is initialized.");

  END InitializeTable;
      
  PROCEDURE Insert (T       : IN OUT TableType; 
                    E       : ElementType;
                    Success : OUT Boolean) IS
  BEGIN -- Insert

    Enter(Subprogram => "Insert");

    Success := True;

    -- First search table for E's ID; set Success false if found
    FOR Which IN 1..T.CurrentSize LOOP
      IF Employees.RetrieveID(T.ActualElements(Which)) =
         Employees.RetrieveID(E) THEN
        Success := False;
        RETURN;
      END IF;
    END LOOP;

    -- we didn't find a matching record, so we can insert this one
    T.CurrentSize := T.CurrentSize + 1;
    T.ActualElements(T.CurrentSize) := E;
    
    Leave(Subprogram => "Insert");

  END Insert;
 
  PROCEDURE Traverse (T : TableType) IS
  BEGIN -- Traverse

    Enter(Subprogram => "Traverse");

    FOR Count IN 1..T.CurrentSize LOOP
      Employees.IO.Put(Item => T.ActualElements(Count));
      Ada.Text_IO.New_Line;
    END LOOP;

    Leave(Subprogram => "Traverse");

  END Traverse;
      
  PROCEDURE Retrieve (T       : TableType;
                      Target  : KeyType;
                      E       : OUT ElementType;
                      Success : OUT Boolean) IS
  BEGIN -- stub

    Enter(Subprogram => "Retrieve", Message => "under construction");
    Leave(Subprogram => "Retrieve");

  END Retrieve;
      
  PROCEDURE Delete (T       : IN OUT TableType; 
                    Target  : KeyType;
                    Success : OUT Boolean) IS
  BEGIN -- stub

    Enter(Subprogram => "Retrieve", Message => "under construction");
    Leave(Subprogram => "Retrieve");

  END Delete;
 
END Tables;
