WITH Ada.Text_IO;
WITH CPUClock;
USE TYPE CPUClock.CPUSecond;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE TestClok IS
------------------------------------------------------------------
--| An example program to show how the CPUClock operations
--| can be used
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------

  TrialTime      : CPUClock.CPUSecond;   -- CPU time for each trial
  TotalTime      : CPUClock.CPUSecond;   -- total time for all trials
  NumberOfTrials : CONSTANT Integer := 10;
  NumberOfCycles : CONSTANT Integer := 5;

  Maxindex       : CONSTANT Integer := 50;
  A              : ARRAY (1 .. Maxindex, 1 .. Maxindex) OF Integer;

BEGIN -- TestClok

  TotalTime := 0.0;

  FOR Trial IN 1 .. NumberOfTrials LOOP

    CPUClock.ResetCPUTime;
   
    -- this loop runs each trial a number of times before
    -- reading the clock, which allows the time to build up to
    -- a more easily measured value   
    FOR Cycle IN 1 .. NumberOfCycles LOOP   

      -- this pair of loops is really the algorithm being timed;
      -- for MaxIndex = 50 we are doing 2,500 multiplications
      FOR Row IN 1 .. Maxindex LOOP
        FOR Col IN 1 .. Maxindex LOOP
          A (Row, Col) := Row * Col;
        END LOOP;
      END LOOP;

    END LOOP;

    -- read clock; accumulate total time
    TrialTime := CPUClock.CPUTime;
    TotalTime := TotalTime + TrialTime;

    -- display results for this trial
    Ada.Text_IO.Put(Item => "Trial ");
    Ada.Integer_Text_IO.Put(Item => Trial, Width => 1);
    Ada.Text_IO.Put (Item => " time used ");
    Ada.Float_Text_IO.Put (Item => TrialTime, Fore => 1, Aft => 2, Exp => 0);
    Ada.Text_IO.Put (Item => " seconds; total time so far ");
    Ada.Float_Text_IO.Put (Item => TotalTime, Fore => 1, Aft => 2, Exp => 0);
    Ada.Text_IO.Put(Item => " seconds.");
    Ada.Text_IO.New_Line;
    Ada.Text_IO.New_Line;
    
  END LOOP;

END TestClok;
