WITH Ada.Text_IO; USE Ada.Text_IO;
WITH Singly_Linked_Lists; USE Singly_Linked_Lists;
PROCEDURE Test_Lists IS
------------------------------------------------------------------
--|                                                              
--| illustrates the singly linked list package operations
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
--|                                                              
------------------------------------------------------------------

  L1: List;
  L2: List;

BEGIN -- Test_Lists

  -- first test the traverse and copy operations for empty list 

  Ada.Text_IO.Put_Line(Item => "--------");
  Traverse(L1);
  Ada.Text_IO.New_Line;
  L2 := Copy(L1);
  Traverse(L2);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put_Line(Item => "--------");

  -- add to end of empty list

  AddToEnd(L1, "Hat");
  Traverse(L1);
  Ada.Text_IO.New_Line;
  L2 := Copy(L1);
  Traverse(L2);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put_Line(Item => "--------");

  -- add to end of nonempty list

  AddToEnd(L1, "Boy");
  Traverse(L1);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put_Line(Item => "--------");

  -- add again to end of nonempty list

  AddToEnd(L1, "Cat");
  Traverse(L1);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put_Line(Item => "--------");

  -- add to front of nonempty list and copy result

  AddToFront(L1, "Top");
  Traverse(L1);
  Ada.Text_IO.New_Line;
  L2 := Copy(L1);
  Traverse(L2);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put_Line(Item => "--------");

END Test_Lists;
