WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
WITH Metric_System; USE Metric_System;
PROCEDURE Test_Metric IS
------------------------------------------------------------------
--| Test some of the operations of the metric system package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  V   : Velocity;
  T   : Time;
  D   : Length;
  A   : Area;
  Vol : Volume;

BEGIN -- Test_Metric

  -- these operations should all work correctly

  V := 23.0 * M_per_Sec;
  T := 3600.0 * Sec;

  D := V * T;

  Ada.Text_IO.Put("Distance = Rate * Time works as advertised");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put("Distance is ");
  Ada.Float_Text_IO.Put(Item => Value(D), Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.Put(" meters.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.New_Line;

  D := 3.0 * Meter;
  A := D * D;

  Ada.Text_IO.Put("Area = Distance * Distance works as advertised");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put("Area is ");
  Ada.Float_Text_IO.Put(Item => Value(A), Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.Put(" square meters.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.New_Line;

  Vol := A * D;

  Ada.Text_IO.Put("Volume = Area * Distance works as advertised");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put("Volume is ");
  Ada.Float_Text_IO.Put(Item => Value(Vol), Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.Put(" cubic meters.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.New_Line;

  D := D + D;

  Ada.Text_IO.Put("Distance = Distance + Distance works as advertised");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put("Distance is ");
  Ada.Float_Text_IO.Put(Item => Value(D), Fore => 1, Aft => 2, Exp => 0);
  Ada.Text_IO.Put(" meters.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.New_Line;

  BEGIN -- block for exception handler
    D := D * D;
    Ada.Text_IO.Put("Distance = Distance * Distance worked, but should not");
    Ada.Text_IO.New_Line;
  EXCEPTION
    WHEN Constraint_Error =>
      Ada.Text_IO.Put("Constraint Error Raised on Distance = Distance * Distance");
      Ada.Text_IO.New_Line;
    WHEN Dimension_Error =>
      Ada.Text_IO.Put("Dimension Error Raised on Distance = Distance * Distance");
      Ada.Text_IO.New_Line;
  END; -- exception block

  BEGIN -- block for exception handler
    D := T + D;
    Ada.Text_IO.Put("Distance = Time + Distance worked, but should not");
    Ada.Text_IO.New_Line;
  EXCEPTION
    WHEN Constraint_Error =>
      Ada.Text_IO.Put("Constraint Error Raised on Distance = Time + Distance");
      Ada.Text_IO.New_Line;
    WHEN Dimension_Error =>
      Ada.Text_IO.Put("Dimension Error Raised on Distance = Time + Distance");
      Ada.Text_IO.New_Line;
  END; -- exception block

END Test_Metric;
