-- VANILLA.ADA   Ver. 3.00   22-AUG-1994   Copyright 1988-1994 John J. Herro
-- Software Innovations Technology
-- 1083 Mandarin Drive NE, Palm Bay, FL  32905-4706   (407)951-0233
--
-- "Plain vanilla" version of CUSTOM_IO which should work with ANY standard Ada
-- compiler.  Compile this before compiling ADA_TUTR.ADA.
--
with Text_IO;
package Custom_IO is
   type Color is (Black, Red, Green, Yellow, Blue, Magenta, Cyan, White);
   Foregrnd_Color   : Color := White;                 -- Default values in case
   Backgrnd_Color   : Color := Black;                 -- ADA-TUTR finds no User
   Border_Color     : Color := Black;                 -- File.
   Fore_Color_Digit : Character := Character'Val(Color'Pos(Foregrnd_Color)+48);
   Back_Color_Digit : Character := Character'Val(Color'Pos(Backgrnd_Color)+48);
   Normal_Colors    : String(1 .. 10) := ASCII.ESC & "[0;3" &
                              Fore_Color_Digit & ";4" & Back_Color_Digit & "m";
   Clear_Scrn       : constant String := ASCII.ESC & "[H" & ASCII.ESC & "[2J";

   procedure Set_Border_Color (To   : in  Color);
   procedure Get              (Char : out Character) renames Text_IO.Get;
   procedure Put              (Char : in  Character) renames Text_IO.Put;
   procedure Put              (Str  : in  String)    renames Text_IO.Put;
   procedure Put_Line         (Str  : in  String)    renames Text_IO.Put_Line;
   procedure Get_Line         (Str  : out String;
                               Last : out Natural)   renames Text_IO.Get_Line;
   procedure New_Line      (Spacing : in  Text_IO.Count := 1)
                                                     renames Text_IO.New_Line;
end Custom_IO;

package body Custom_IO is
   procedure Set_Border_Color(To : in Color) is
      --
      -- This is a dummy procedure.  If your PC Ada compiler allows interrupt
      -- calls or assembly language, you may want to write code to call
      -- interrupt 10 hex.  (See JANUS.ADA and MERIDIAN.ADA for examples.)
      -- Before the call, set register AH to service number 0B hex, set BH to
      -- zero, and set BL to Color_Number(To), where Color_Number is declared
      -- below.  Note that the integers in Color_Number are bit reversed from
      -- the integers defining foreground and background colors in ANSI escape
      -- sequences.  Note also that some color PCs don't have separate border
      -- colors.
      --
      Color_Number : constant array(Color) of Integer :=
          (Black   => 0,   Red     => 4,   Green   => 2,   Yellow  => 6,
           Blue    => 1,   Magenta => 5,   Cyan    => 3,   White   => 7);
   begin
      null;
   end Set_Border_Color;
end Custom_IO;
