WITH Ada.Text_IO;
WITH Ada.Characters.Handling;
WITH Ada.Strings.Maps;
WITH Ada.Strings.Fixed;
PROCEDURE Cryptogram_2 IS
------------------------------------------------------------------
--| Program to generate a cryptogram, using Ada 95 facilities
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  SUBTYPE Message IS String(1..60);

  Code      : String(1..26);       -- input - string of code symbols
  PlainText : Message;            -- input - plain text message

  CodedText : Message;            -- output - coded message

  CodeMap   : Ada.Strings.Maps.Character_Mapping;
  HowLong   : Natural;   
   
BEGIN -- Cryptogram_2   

  Ada.Text_IO.Put(Item => "Enter a code symbol under each letter.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "ABCDEFGHIJKLMNOPQRSTUVWXYZ");  
  Ada.Text_IO.New_Line;

  -- Read code string from terminal, convert to mapping
  Ada.Text_IO.Get(Item => Code);
  Ada.Text_IO.Skip_Line;
  CodeMap := Ada.Strings.Maps.To_Mapping
    (From => "ABCDEFGHIJKLMNOPQRSTUVWXYZ", To => Code);

  -- Read plain text message
  Ada.Text_IO.Put(Item => "Enter each character of your message.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "No more than 60 characters, please.");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "Press RETURN after your message.");
  Ada.Text_IO.New_Line;

  -- Display scale so user knows how many characters
  Ada.Text_IO.Put(Item => "         1         2         3" &
                          "         4         5         6");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "123456789012345678901234567890" &
                          "123456789012345678901234567890");
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Get_Line (Item => PlainText, Last => HowLong);

  -- Encode message using Translate function
  CodedText(1..HowLong) := 
    Ada.Strings.Fixed.Translate 
    (Source => 
      Ada.Characters.Handling.To_Upper
        (Item => PlainText(1..HowLong)),
     Mapping => CodeMap);

  -- Display coded message
  Ada.Text_IO.Put (Item => CodedText(1..HowLong));
  Ada.Text_IO.New_Line;

END Cryptogram_2;
