WITH Employees;
PACKAGE Database IS
------------------------------------------------------------------
--| Specification of the abstract data object for a database
--| of employee records
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  -- Exported Exception

  DatabaseFull: EXCEPTION;

  -- Operations  

  PROCEDURE Initialize;
  -- Pre : None
  -- Post: Database is emptied of all records
     
  PROCEDURE Insert (E       : Employees.Employee;
                    Success : OUT Boolean);
  --  Pre   : E is defined
  --  Post  : Inserts new element E into database
  --    Success is True if insertion is performed, and False
  --    if database already has an element with the same ID as E.
  --  Raises: DatabaseFull if the database is full before insertion
     
  PROCEDURE Replace (E       : Employees.Employee;
                     Success : OUT Boolean);
  --  Pre   : E is defined
  --  Post  : Finds record in database with E's ID, and replaces it
  --    with E. Success is True if replacement is performed, and False
  --    if database has no element with the same ID as E.
     
  PROCEDURE Retrieve (ID      : IN  Employees.IDType;
                      E       : OUT Employees.Employee;
                      Success : OUT Boolean);
  --  Pre : ID is defined
  --  Post: Copies into E the database record with the given ID 
  --    Success is True if the copy is performed, and False
  --    if database has no element with the given ID   
     
  PROCEDURE Delete (ID      : IN Employees.IDType;
                    Success : OUT Boolean);
  --  Pre : ID is defined
  --  Post: Deletes from database the record with the given ID 
  --    Success is True if deletion is performed, and False
  --    if database has no element with the given ID   

  PROCEDURE Display;
  --  Pre : None
  --  Post: The database records are displayed in order by ID

END Database;
