WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
WITH Ada.Numerics.Elementary_Functions;
USE  Ada.Numerics.Elementary_Functions;
PROCEDURE Distance_between_Points IS
------------------------------------------------------------------
--| Finds the distance between two points on the x-y plane.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  TYPE Point IS RECORD
    X : Float;
    Y : Float;
  END RECORD;

  Point1 : Point;              -- one data point   
  Point2 : Point;              -- the other data point   

  PROCEDURE GetPoint(Item: OUT Point) IS
  -- Pre: none
  -- Post: the point, Item, is defined with values from the user

  BEGIN

    Ada.Text_IO.Put(Item => "Enter X coordinate (floating point) > ");  
    Ada.Float_Text_IO.Get(Item => Item.X);
    Ada.Text_IO.Put(Item => "Enter Y coordinate (floating point) > ");  
    Ada.Float_Text_IO.Get(Item => Item.Y);

  END GetPoint;


  FUNCTION Distance(P1 : Point; P2 : Point) RETURN Float IS
  -- Pre: P1 and P2 are defined
  -- Post: returns the Cartesian distance between the points

  BEGIN

    RETURN Sqrt((P2.X-P1.X) ** 2 + (P2.Y-P1.Y) ** 2);

  END Distance;

BEGIN -- Distance_between_Points   

  Ada.Text_IO.Put(Item => "First Point");
  Ada.Text_IO.New_Line;
  GetPoint(Item => Point1);
  Ada.Text_IO.Put(Item => "Second Point");
  Ada.Text_IO.New_Line;
  GetPoint(Item => Point2);
  Ada.Text_IO.Put(Item => "Distance between points is ");
  Ada.Float_Text_IO.Put
    (Item => Distance(Point1, Point2), Fore=>1,Aft=>2,Exp=>0);
  Ada.Text_IO.New_Line;

END Distance_between_Points;
