WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Estimate_e IS
------------------------------------------------------------------
--| Computes the value of e by a series approximation.   
--| Number of places of accuracy is specified by user input.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  Places  : Positive; -- Input - number of decimal places of accuracy
  e       : Float;    -- Output - the value being approximated   

  eOld    : Float;    -- the value being approximated   
  i       : Natural;  -- to produce the i-th term
  ithTerm : Float;    -- ith term in series   
  n       : Positive; -- number of terms in series   
  Epsilon : Float;    -- desired difference between successive tries

BEGIN -- Estimate_e

  Ada.Text_IO.Put(Item => "Enter desired number of decimal places > ");
  Ada.Integer_Text_IO.Get(Item => Places);  

  Epsilon := 1.0 / (10.0 ** Places);

  Ada.Text_IO.Put(Item => "Number of Terms  Approximate Value of e");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "---------------  ----------------------");
  Ada.Text_IO.New_Line;

  -- Compute each term and add it to the accumulating sum.   
  e := 1.0;             -- initial sum   
  ithTerm := 1.0;       -- first term   
  i := 0;
  LOOP -- and quit when desired accuracy is achieved

    eOld := e;          -- save previous approximation

    i := i + 1;
    ithTerm := ithTerm / Float(i);

    e := e + ithTerm;   -- find new value

    Ada.Integer_Text_IO.Put(Item => i, Width => 9);
    Ada.Float_Text_IO.Put
      (Item => e, Fore => 10, Aft => Places+2, Exp => 0);
    Ada.Text_IO.New_Line;

    EXIT WHEN ABS (e - eOld) <= Epsilon;

  END LOOP;

END Estimate_e;
