PACKAGE Geometry IS
------------------------------------------------------------------
--| Defines an abstract data type for a geometric figure.  
--| Operations include constructors for rectangles, circles, 
--| and squares, and selectors for width, height, side,
--| area and perimeter.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------
  
  -- Data Types
  
  SUBTYPE NonNegFloat IS Float RANGE 0.0 .. Float'Last;
  TYPE FigKind IS (Rectangle, Square, Circle);

  TYPE Figure (FigShape : FigKind := Rectangle) IS PRIVATE;

  -- Exported Exception

  ShapeError: EXCEPTION;
  
  -- Constructor Operations 

  FUNCTION MakeRectangle (Width, Height : NonNegFloat) RETURN Figure;
  -- Pre : Width and Height are defined
  -- Post: returns a rectangle

  FUNCTION MakeCircle (Radius : NonNegFloat) RETURN Figure;
  -- Pre : Radius is defined
  -- Post: returns a circle

  FUNCTION MakeSquare (Side : NonNegFloat) RETURN Figure;
  -- Pre : Side is defined
  -- Post: returns a square
  
  -- selectors
  FUNCTION Shape     (OneFig : Figure) RETURN FigKind;   
  FUNCTION Height    (OneFig : Figure) RETURN NonNegFloat;
  FUNCTION Width     (OneFig : Figure) RETURN NonNegFloat;
  FUNCTION Radius    (OneFig : Figure) RETURN NonNegFloat;
  FUNCTION Side      (OneFig : Figure) RETURN NonNegFloat;
  FUNCTION Perimeter (OneFig : Figure) RETURN NonNegFloat;
  FUNCTION Area      (OneFig : Figure) RETURN NonNegFloat;
  -- Pre   : OneFig is defined.
  -- Post  : Returns the appropriate characteristic
  -- Raises: ShapeError if the requested characteristic is
  --         undefined for the shape of OneFig 

PRIVATE

  TYPE Figure (FigShape : FigKind := Rectangle) IS RECORD
    Area : NonNegFloat := 0.0;
    Perimeter : NonNegFloat := 0.0;
    CASE FigShape IS
      WHEN Rectangle | Square =>
        Width : NonNegFloat := 0.0;
        Height : NonNegFloat := 0.0;
      WHEN Circle =>
        Radius : NonNegFloat := 0.0;
    END CASE;  
  END RECORD;  

END Geometry;
