WITH Stacks_Generic;
FUNCTION IsBalanced (Expression: String) RETURN Boolean IS
------------------------------------------------------------------
--| Determines whether a string is balanced with respect to
--| parentheses () [] and {}
--| Author: Michael B. Feldman, The George Washington University
--| Last Modified: September 1995
------------------------------------------------------------------

  -- Pre:  Expression is defined
  -- Post: Returns True if Expression is balanced, False otherwise


  PACKAGE Char_Stacks IS NEW Stacks_Generic(StackElement => Character);
  USE Char_Stacks;
  
  ParenStack: Stack;         -- stack of open parentheses
  NextChar  : Character;     -- next character in input expression
  OpenParen : Character;     -- open parenthesis at top of stack
  Index     : Positive;      -- index to Expression
  Balanced  : Boolean;       -- program flag

BEGIN -- IsBalanced

  MakeEmpty (ParenStack);
  Balanced := True;
  Index := Expression'First;

  WHILE Index <= Expression'Last AND THEN Balanced LOOP
  -- Invariant:
  --   All close parentheses so far were matched and Index
  --   is within the range of Expression
    NextChar := Expression (Index);
    CASE NextChar IS

      WHEN '(' | '[' | '{' =>
        Push (ParenStack, NextChar);     -- Push open parenthesis

      WHEN ')' | ']' | '}' =>
        IF IsEmpty (ParenStack) THEN
          Balanced := False;
        ELSE
          OpenParen := Top (ParenStack); -- Get nearest open paren
          Pop (ParenStack);
          CASE NextChar IS               -- Do open and close match?
            WHEN ')' =>
              Balanced := OpenParen = '(';
            WHEN ']' =>
              Balanced := OpenParen = '[';
            WHEN '}' =>
              Balanced := OpenParen = '{';
            WHEN OTHERS =>
              NULL;
          END CASE;
        END IF;

      WHEN OTHERS =>
        NULL;

    END CASE;
    Index := Index + 1;                  -- move on to next character
  END LOOP;

  RETURN Balanced AND IsEmpty (ParenStack);

END IsBalanced;
