WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
WITH Screen;
PROCEDURE Menu_Handler IS
------------------------------------------------------------------
--| Framework for a menu-handling program
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  SUBTYPE Commands IS Positive RANGE 1..6;
  MenuSelection : Commands;

BEGIN -- Menu_Handler

  LOOP   -- this is the outer loop that keeps the program running 
         -- until a "quit" command is entered.

    LOOP -- inner loop continues until valid input is entered
      BEGIN -- exception handler block

        Screen.ClearScreen;
        Screen.MoveCursor (Row => 5, Column => 20);
        Ada.Text_IO.Put (Item => "Select one of the operations below.");
        Screen.MoveCursor (Row => 7, Column => 20);
        Ada.Text_IO.Put (Item => "1. Compute an Average");
        Screen.MoveCursor (Row => 8, Column => 20);
        Ada.Text_IO.Put (Item => "2. Compute a Standard Deviation");
        Screen.MoveCursor (Row => 9, Column => 20);
        Ada.Text_IO.Put (Item => "3. Find the Median");    
        Screen.MoveCursor (Row => 10, Column => 20);
        Ada.Text_IO.Put (Item => "4. Find the smallest and largest values");
        Screen.MoveCursor (Row => 11, Column => 20);
        Ada.Text_IO.Put (Item => "5. Plot the data");     
        Screen.MoveCursor (Row => 12, Column => 20);
        Ada.Text_IO.Put (Item => "6. Quit the program");   

        Screen.MoveCursor (Row => 14, Column => 20);
        Ada.Text_IO.Put ("Enter a command, 1 through 6 > ");

        -- this statement could raise an exception if input 
        -- is out of range or not an integer value
        Ada.Integer_Text_IO.Get (Item => MenuSelection);

        -- these statements are executed only if command is valid  
        -- otherwise, control passes to exception handler
        Screen.MoveCursor (Row => 17, Column => 20);
        Ada.Text_IO.Put ("Thank you for correct input.");      
        EXIT;      -- valid command; go process it

      EXCEPTION    -- invalid command
      
        WHEN Ada.Text_IO.Data_Error =>
          Screen.MoveCursor (Row => 17, Column => 20);
          Ada.Text_IO.Put (Item => "Value entered is not an integer.");
          Ada.Text_IO.Skip_Line;
          Ada.Text_IO.New_Line;
          DELAY 2.0;
        WHEN Constraint_Error =>  
          Screen.MoveCursor (Row => 17, Column => 20);
          Ada.Text_IO.Put (Item => "Value entered is out of range.");   
          Ada.Text_IO.New_Line;
          DELAY 2.0;

      END;         -- of exception handler block
    END LOOP;

    -- We come here if command was valid; exit if it was quit 
    Screen.MoveCursor (Row =>20, Column => 20);
    EXIT WHEN MenuSelection = 6;

    Ada.Text_IO.Put (Item => "Here we would carry out the command.");
    Ada.Text_IO.New_Line;
    DELAY 5.0;

  END LOOP;

  Ada.Text_IO.Put (Item => "Goodbye for today.");
  Ada.Text_IO.New_Line;

END Menu_Handler;
