PACKAGE Robust_Input IS
------------------------------------------------------------------
--| Package for getting numeric input robustly.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
-----------------------------------------------------------------:

  PROCEDURE Get (Item : OUT Integer; 
                 MinVal : IN Integer; 
                 MaxVal : IN Integer);
  -- Gets an integer value in the range MinVal..MaxVal from the terminal
  -- Pre: MinVal and MaxVal are defined
  -- Post: MinVal <= Item <= MaxVal


  PROCEDURE Get (Item : OUT Float; 
                 MinVal : IN Float; 
                 MaxVal : IN Float);
  -- Gets a float value in the range MinVal..MaxVal from the terminal
  -- Pre: MinVal and MaxVal are defined
  -- Post: MinVal <= Item <= MaxVal

END Robust_Input;
