WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
WITH Ada.Numerics;
USE  Ada.Numerics;
WITH Ada.Numerics.Elementary_Functions;
USE  Ada.Numerics.Elementary_Functions;
PROCEDURE Sine_Curve IS
------------------------------------------------------------------
--| Plots a sine curve.   
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  RadPerDegree : CONSTANT Float   := Pi / 180.0;  
                                             -- radians per degree   
                                             -- Pi in Ada.Numerics
  MinAngle :     CONSTANT Float   := 0.0;    -- smallest angle   
  MaxAngle :     CONSTANT Float   := 360.0;  -- largest angle   
  PlotWidth :    CONSTANT Integer := 40;     -- width of plot   
  PlotHeight :   CONSTANT Integer := 20;     -- height of plot   
  StepAngle :    CONSTANT Float := (MaxAngle-MinAngle) / Float(PlotHeight);  
                                             -- change in angle   
  Star :         CONSTANT Character := '*';  -- symbol being plotted   
  Blank:         CONSTANT Character := ' ';  -- to "pad" the '*'

  SUBTYPE ColumnRange IS Integer RANGE 0..PlotWidth;

  Angle  :       Float;                      -- angle in degrees   
  Radian :       Float;                      -- angle in radians   
  Scale :        Float;                      -- scale factor   
  Pad :          ColumnRange;                -- size of blank padding   

BEGIN  -- Sine_Curve   

  Ada.Text_IO.Put(Item => "                   Sine curve plot");
  Ada.Text_IO.New_Line(2);
  Scale := Float(PlotWidth / 2);
  Angle := MinAngle;

  WHILE Angle <= MaxAngle LOOP

    Radian := Angle * RadPerDegree;
    Pad := Natural(Scale * (1.0 + Sin(Radian)));

    Ada.Float_Text_IO.Put
      (Item =>Angle, Fore => 4, Aft => 0, Exp => 0);  

    -- Display blank padding   
    Ada.Text_IO.Put(Item => Blank);
    FOR BlankCount IN 1 .. Pad LOOP
      Ada.Text_IO.Put(Item => Blank);
    END LOOP;       

    Ada.Text_IO.Put(Item => Star);      -- Plot * in next column   
    Ada.Float_Text_IO.Put
      (Item =>Sin(Radian), Fore => 6, Aft => 6, Exp => 0);  
    Ada.Text_IO.New_Line;
    Angle := Angle + StepAngle;

  END LOOP;

END Sine_Curve;
