WITH Lists_Generic;
GENERIC
  TYPE StackElement IS PRIVATE;
PACKAGE Stacks_Generic IS
------------------------------------------------------------------
--| Generic package for LIFO stacks
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  -- type definition

  TYPE Stack IS LIMITED PRIVATE;

  -- exported exceptions

  StackEmpty : EXCEPTION;

  -- constructors

  PROCEDURE MakeEmpty (S : IN OUT Stack);
  -- Pre:    S is defined
  -- Post:   S is empty

  PROCEDURE Push (S : IN OUT Stack; E : IN StackElement);
  -- Pre:    S and E are defined
  -- Post:   S is returned with E as the top StackElement

  PROCEDURE Pop (S : IN OUT Stack);
  -- Pre:    S is defined
  -- Post:   S is returned with the top StackElement discarded
  -- Raises: StackEmpty if S contains no StackElements

  -- selector

  FUNCTION Top (S : IN Stack) RETURN StackElement;
  -- Pre:    S is defined
  -- Post:   The top StackElement of S is returned
  -- Raises: StackEmpty if S contains no StackElements

  -- inquiry operations

  FUNCTION IsEmpty (S : IN Stack) RETURN Boolean;
  -- Pre:    S is defined
  -- Post:   returns True if S is empty, False otherwise

PRIVATE

  PROCEDURE Dummy (Item: StackElement);

  PACKAGE Lists IS
    NEW Lists_Generic(ElementType => StackElement, DisplayElement => Dummy);

  TYPE Stack IS RECORD
    Store : Lists.List;
  END RECORD;

END Stacks_Generic;
