WITH Ada.Text_IO;
WITH Dates;
WITH Dates.IO;
PROCEDURE Test_Dates IS
------------------------------------------------------------------
--| Demonstration of Dates package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  D: Dates.Date;

BEGIN -- Test_Dates

  -- first test the function Today
  D := Dates.Today;
  Ada.Text_IO.Put(Item => "Today is ");
  Ada.Text_IO.New_Line;
  Dates.IO.Put(Item => D, Format => Dates.IO.Short);
  Ada.Text_IO.New_Line;
  Dates.IO.Put(Item => D, Format => Dates.IO.Full);
  Ada.Text_IO.New_Line;
  Dates.IO.Put(Item => D, Format => Dates.IO.Numeric);
  Ada.Text_IO.New_Line;

  LOOP

    BEGIN -- block for exception handler
      Ada.Text_IO.Put("Please enter a date in MMM DD YYYY form > ");
      Dates.IO.Get(Item => D);
      EXIT; -- only if no exception is raised
    EXCEPTION
      WHEN Dates.Date_Error =>
        Ada.Text_IO.Skip_Line;
        Ada.Text_IO.Put(Item => "Badly formed date; try again, please.");
        Ada.Text_IO.New_Line;
    END;

  END LOOP;
  -- assert: at this point, D contains a correct date record

  Ada.Text_IO.Put(Item => "You entered ");
  Ada.Text_IO.New_Line;
  Dates.IO.Put(Item => D, Format => Dates.IO.Short);
  Ada.Text_IO.New_Line;
  Dates.IO.Put(Item => D, Format => Dates.IO.Full);
  Ada.Text_IO.New_Line;
  Dates.IO.Put(Item => D, Format => Dates.IO.Numeric);
  Ada.Text_IO.New_Line;

END Test_Dates;
