WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Test_Tower IS
------------------------------------------------------------------------
--| Demonstration of the recursive procedure Tower,
--| which solves a 3-peg Towers of Hanoi problem
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------------

  SUBTYPE Pegs IS Character RANGE 'A'..'C';

  PROCEDURE MoveDisk (FromPeg, ToPeg: Pegs; Which: Natural) IS

  -- Auxiliary procedure implementing a 1-disk move

  BEGIN
    Ada.Text_IO.Put(Item => "Move disk ");
    Ada.Integer_Text_IO.Put(Item => Which, Width => 1);
    Ada.Text_IO.Put(Item => " from peg ");
    Ada.Text_IO.Put(Item => FromPeg);
    Ada.Text_IO.Put(Item => " to peg ");
    Ada.Text_IO.Put(Item => ToPeg);
    Ada.Text_IO.New_Line;
  END MoveDisk;

  PROCEDURE Tower (FromPeg, ToPeg, AuxPeg: Pegs; N: Natural) IS

  -- Moves N disks from FromPeg to ToPeg
  -- using AuxPeg as an auxiliary.   

  BEGIN  -- Tower  

    IF N = 1 THEN
      -- stopping case
      MoveDisk(FromPeg, ToPeg, 1);
    ELSE
      -- recursive step   
      Tower (FromPeg, AuxPeg, ToPeg, N-1);
      MoveDisk(FromPeg, ToPeg, N);
      Tower (AuxPeg, ToPeg, FromPeg, N-1);
    END IF;

  END Tower;

BEGIN -- Test_Tower

  Tower (FromPeg => 'A', ToPeg => 'B', AuxPeg => 'C', N => 5);

END Test_Tower;
