WITH Ada.Text_IO;
WITH Ada.Calendar;
WITH Ada.Integer_Text_IO;
PROCEDURE Todays_Date IS
------------------------------------------------------------------
--|                                                              
--| Finds and displays today's date in the form mm/dd/yy
--| The date is gotten from PACKAGE Ada.Calendar
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------
 
  Right_Now  : Ada.Calendar.Time;           -- holds internal clock value
  This_Year  : Ada.Calendar.Year_Number;    -- holds current year
  This_Month : Ada.Calendar.Month_Number;   -- holds current month 
  This_Day   : Ada.Calendar.Day_Number;     -- holds current day
 
  Last_Two_Digits : Natural;
  This_century    : CONSTANT Integer := 1900; 
   
BEGIN -- Todays_Date 
 
  -- Get the current time value from the computer's clock
  Right_Now := Ada.Calendar.Clock;
 
  -- Extract the current month, day, and year from the time value 
  This_Month := Ada.Calendar.Month(Date => Right_Now);
  This_Day   := Ada.Calendar.Day  (Date => Right_Now);
  This_Year  := Ada.Calendar.Year (Date => Right_Now);
 
  -- Format and display the date
  Last_Two_Digits := This_Year - This_Century;
 
  Ada.Text_IO.Put (Item => "Today's date is ");
  Ada.Integer_Text_IO.Put (Item => This_Month, Width => 1);
  Ada.Text_IO.Put (Item => '/');
  Ada.Integer_Text_IO.Put (Item => This_Day, Width => 1);
  Ada.Text_IO.Put (Item => '/');
  Ada.Integer_Text_IO.Put (Item => Last_Two_Digits, Width => 1); 
  Ada.Text_IO.New_Line;
 
END Todays_Date;
