WITH Text_IO;
WITH Screen;
PROCEDURE FourPieces IS

-- this program divides the screen into four pieces by drawing horizontal
-- and vertical lines. The Screen package is used to position the cursor.

BEGIN

  Screen.ClearScreen;
  
  FOR Count IN Screen.Height LOOP
    Screen.MoveCursor (To => (Row => Count, Column => 41));
    Text_IO.Put (Item => '|');
    Screen.MoveCursor (To => 
      (Row => (Screen.ScreenHeight - Count) + 1, Column => 42));
    Text_IO.Put (Item => '|');
  END LOOP;
  
  FOR Count IN Screen.Width LOOP
    Screen.MoveCursor (To => (Row => 12, Column => Count));
    Text_IO.Put (Item => '-');
    Screen.MoveCursor (To => 
      (Row => 13, Column => (Screen.ScreenWidth - Count) + 1));
    Text_IO.Put (Item => '-');
  END LOOP;

  Screen.MoveCursor (To => (Row => 24, Column => 1));

END FourPieces;
