

/*
    GWMON Parallel Ada Monitor for 386/486 PCs   
    Copyright (C) 1993, Charles W. Kann  & Michael Bliss Feldman
                        ckann@seas.gwu.edu mfeldman@seas.gwu.edu
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ed.h"

struct FL {
	FILE_REC_PTR FD;
	struct FL *nxt;	
	} FILE_LIST, *FILE_LIST_PTR;


FILE_REC_PTR CWK_LOAD_FILE( file_name )
char *file_name;
{
    int ch;
    FILE_REC_PTR tmp_fn;
    char buffer[100], msg[100];
    int line_cnt = 0, length;
    static struct FL *First_FL = NULL, *Next_FL;

    /*  
	Only allocate a new file if the current one is not open.
    */

    Next_FL = First_FL;

    /************************************************************************/
    /*    This is a way to deal with seperate compilations of package       */
    /*	  specifications and bodies.  If the specification is in a ".ads"   */
    /*    file, and the body in a ".adb" file, then always open the ".abd"  */
    /*    file.								    */
    /************************************************************************/

    length = strlen( file_name );
    if ( strncmp( &file_name[length-3], "ads", 3 ) == 0 )
	strcpy( &file_name[length-3], "adb" );

    while (  Next_FL != NULL )
    {
    	if ( ! strcmp( Next_FL->FD->FN, file_name ) ) 
    	    return Next_FL->FD;
	Next_FL = Next_FL->nxt;
    }

    Next_FL = malloc( sizeof( FILE_LIST ) );
    Next_FL->nxt = First_FL;
    First_FL = Next_FL;

    tmp_fn = malloc( sizeof( FILE_REC ));
    Next_FL->FD = tmp_fn;
    tmp_fn->FN = malloc( strlen( file_name )+1 );
    strcpy( tmp_fn->FN, file_name );

    tmp_fn->fd = fopen( tmp_fn->FN, "r" );
    if (tmp_fn->fd == 0) {
        sprintf( msg, "Can't open file %s", file_name );
	CWK_CLEANUP_MON( -1, msg );
	}
    
    while ( fgets( buffer, 100, tmp_fn->fd ) ) {
	if ( line_cnt >= MAX_LINES )
	{
        	sprintf( msg, "Too many lines in file %s", file_name );
		CWK_CLEANUP_MON( -1, msg );
	}

	tmp_fn->lines[line_cnt] = malloc( strlen(buffer));
        if (tmp_fn->lines[line_cnt] == 0) {
            CWK_CLEANUP_MON( -1,"Out of memory" );
	    }
	strncpy( tmp_fn->lines[line_cnt], buffer, strlen( buffer ) - 1 );
	tmp_fn->lines[line_cnt++][strlen(buffer)-1] = '\0';
	}
    tmp_fn->lines_in_file = line_cnt - 1;
    return tmp_fn;
}
