

/*
    GWMON Parallel Ada Monitor for 386/486 PCs   
    Copyright (C) 1993, Charles W. Kann  & Michael Bliss Feldman
                        ckann@seas.gwu.edu mfeldman@seas.gwu.edu
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ed.h"

#define DISPLAY_ONLY -1
#define PROCESS_WINDOW 1

extern void print_setup_help();

extern int rr_flag;
extern int rr_nb_max_stmts;

static char *speed_choices[] = { "==========", "=========.", "========..",
       "=======...", "======....", "=====.....", "====......", "===.......",
       "==........", "=.........", "" };
static char *small_large[] = { "Small", "Large", "" };
static char *quantum_choices[] = { "1", "2", "3", "4", "5", "10", "25", "50",
				"100", "500", "" };
static char *profile_choices[] = { "100", "200", "300", "400", "500", "1000", 
				   "2000", "5000", "" };

static char *tasking_choices[] = { "Run Til Block", "Round Robin", "" };
static char *delay_choices[] = { "True", "Scaled", "" };
static char *monitor_choices[] = { "Nothing", "Lines", "Exec %", "" };
static char *window_choices[] = { "Four Windows", "Two Windows, Horizonal", 
                                  "Two Windows, Vertical", "One Window", "" };
static char *yes_or_no[] = { "No", "Yes" , ""};

CWK_SETUP_SCREEN()
{
	AVL_WIN_PTR w;
	char msg[81];
	int ch;
	int mode, ret_val;
	int save_mon_type;
	int save_window_type;
	long ret_l_val;

	w = AVL_MAKE_WINDOW( "Monitor Setup - ESC to continue, ? for help", 
		4,2,22,76, 1, 15);
        _settextposition(1, 3);
        sprintf( msg,"Execution Speed (1-10):        Cycles For Reporting Exec %: " );
        _outtext( msg );
        _settextposition(2, 3);
        sprintf( msg,"Delay Time 1 sec =       cycles      RR Statements:" ); 
        _outtext( msg );
        _settextposition(3, 3);
        sprintf( msg,"Type of Tasking: " ); 
        _outtext( msg );
        _settextposition(4, 3);
        sprintf( msg,"Type of Delay: " ); 
        _outtext( msg );
        _settextposition(5, 3);
        sprintf( msg,"Type of Monitoring: " ); 
        _outtext( msg );
        _settextposition(6, 3);
        sprintf( msg,"Line Trace:          Task Trace: " ); 
        _outtext( msg );
        _settextposition(7, 3);
        sprintf( msg,"Type of Monitor Window: " ); 
        _outtext( msg );
        _settextposition(9, 3);
	sprintf( msg, "Use the up and down arrow keys to select between choices" );
        _outtext( msg );

	
	
	mode = DISPLAY_ONLY;
	save_mon_type = monitor_type;
	save_window_type = monitor_window_type;
	
	if ( ( rr_nb_max_stmts < 0 ) && ( rr_nb_max_stmts > 9999 ) ) 
		rr_nb_max_stmts = 0;

TOF:	
	ret_val = CWK_Get_Int( mode, 1, 27, 7, &step_rate, print_setup_help );
	if ( step_rate < 0 )
		step_rate = 0;
	if ( step_rate > MAX_DELAY )
		step_rate = MAX_DELAY;
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Int( mode, 1, 63, 5, &Exec_Report_Time, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Int( mode, 2, 22, 5, &seconds_per_tick, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Int( mode, 2, 59, 5, &rr_nb_max_stmts, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 3, 21, 15, &rr_flag, tasking_choices, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 4, 19, 10, &type_of_delay, 
			delay_choices, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 5, 23, 10, &save_mon_type, 
			monitor_choices, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 6, 16, 3, &step_monitor, 
			yes_or_no, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 6, 38, 3, &task_step, 
			yes_or_no, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 7, 27, 30, &save_window_type, 
			window_choices, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

	mode = PROCESS_WINDOW;
	goto TOF;

LEAVE:	AVL_DEL_WINDOW( w );

	if ( ( save_mon_type != monitor_type ) ||
	     ( save_window_type != monitor_window_type ) )
	{
		CWK_STOP_MONITORING();
		monitor_type = save_mon_type;
		monitor_window_type = save_window_type;
		if ( monitor_type == 1 )
		{
			CWK_SETUP_WINDOWS();
			print_status(); 
		}
	}
}

/***********************************************************************/
/*    The setup menu when the user first enters the system             */
/***********************************************************************/

CWK_FIRST_SETUP()
{
	AVL_WIN_PTR w;
	char msg[81];
	int ch;
	int mode, ret_val;

	w = AVL_MAKE_WINDOW( "Initial Setup Menu", 
		4,2,19,76, 1, 15);
        _settextposition(1, 3);
	_outtext( "RETURN moves between options, UP/DOWN ARROWS to select options\n" );
        _settextposition(2, 3);
	_outtext( "ESC when done" );

       _settextposition(8, 3);
       _outtext( "GWUMON Copyright (C) 1993, Charles W. Kann & Michael Bliss Feldman \n" );
       _outtext( "  GWUMON comes with ABSOLUTELY NO WARRANTY.\n" );
       _outtext( "  This is free software, and you are welcome to redistribute it\n" );
       _outtext( "  under certain conditions; for details type CTRL_K.\n" );

        _settextposition(4, 3);
        sprintf( msg,"Execution Speed          " ); 
        _outtext( msg );

        _settextposition(5, 3);
        sprintf( msg,"Exception Tracing -   " ); 
        _outtext( msg );

        _settextposition(6, 3);
        sprintf( msg,"Does your program use tasks -  " ); 
        _outtext( msg );
	mode = DISPLAY_ONLY;

TOF:	
    	ret_val = CWK_Get_Choice( mode, 4, 28, 11, &step_rate, speed_choices, print_setup_help );
	if ( step_rate < 0 )
		step_rate = 0;
	if ( step_rate > MAX_DELAY )
		step_rate = MAX_DELAY;
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 5, 28, 3, &exception_monitor, 
			yes_or_no, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 6, 34, 3, &task_monitor, 
			yes_or_no, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

	mode = PROCESS_WINDOW;
	goto TOF;

LEAVE:	AVL_DEL_WINDOW( w );

}

/***********************************************************************/
/*    The setup menu when the user uses with sequential monitoring     */
/***********************************************************************/

CWK_SEQ_SETUP()
{
	AVL_WIN_PTR w;
	char msg[81];
	int ch;
	int mode, ret_val;

	w = AVL_MAKE_WINDOW( "Sequential Monitor Menu", 
		4,2,13,76, 1, 15);
        _settextposition(1, 3);
	_outtext( "RETURN moves between options, UP/DOWN ARROWS to select options\n" );
        _settextposition(2, 3);
	_outtext( "ESC when done" );

        _settextposition(4, 3);
        sprintf( msg,"Monitor Window Size     " ); 
        _outtext( msg );

        _settextposition(5, 3);
       sprintf( msg,"When to Pause Execution:   " ); 
        _outtext( msg );

        _settextposition(6, 3);
       sprintf( msg,"      As Program Enter/Exits Procedure - " );
        _outtext( msg );

        _settextposition(7, 3);
       sprintf( msg,"      As Each Line Of Code Is Executed - " );
        _outtext( msg );

	mode = DISPLAY_ONLY;
TOF:	
    	ret_val = CWK_Get_Choice( mode, 4, 28, 6, &Large_Monitor, small_large, 
			print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 6, 45, 3, &task_step, 
			yes_or_no, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 7, 45, 3, &step_monitor, 
			yes_or_no, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;


	mode = PROCESS_WINDOW;
	goto TOF;

LEAVE:	AVL_DEL_WINDOW( w );

	monitor_window_type = 3;
}

/***********************************************************************/
/*    The setup menu when the user uses with sequential monitoring     */
/***********************************************************************/

CWK_TASK_SETUP()
{
	AVL_WIN_PTR w;
	char msg[81];
	int ch;
	int mode, ret_val;
        int choice;
	int save_window_type;
	int save_mon_type;

	w = AVL_MAKE_WINDOW( "Task Monitor Menu", 
		2,2,24,76, 1, 15);
        _settextposition(1, 3);
	_outtext( "RETURN moves between options, UP/DOWN ARROWS to select options\n" );
        _settextposition(2, 3);
	_outtext( "ESC when done" );

        _settextposition(4, 3);
        sprintf( msg,"General Information   " ); 
        _outtext( msg );

        _settextposition(5, 3);
       sprintf( msg,"    What do you want to Monitor - " );
        _outtext( msg );

        _settextposition(6, 3);
       sprintf( msg,"    Type of delay -  " );
        _outtext( msg );

        _settextposition(7, 3);
       sprintf( msg,"    Tasking Model - " );
        _outtext( msg );

        _settextposition(8, 3);
       sprintf( msg,"    If Round Robin : P Code statments per quantum - " );
        _outtext( msg );

        _settextposition(10, 3);
       sprintf( msg,"If monitoring lines as they are executed: " );
        _outtext( msg );

        _settextposition(11, 3);
       sprintf( msg,"    Type of Monitor Window - " );
        _outtext( msg );

        _settextposition(12, 3);
       sprintf( msg,"    When to Pause Execution:   " ); 
        _outtext( msg );

        _settextposition(13, 3);
       sprintf( msg,"          As Program Enter/Exits Procedure - " );
        _outtext( msg );

        _settextposition(14, 3);
       sprintf( msg,"          As Each Line Of Code Is Executed - " );
        _outtext( msg );

        _settextposition(15, 3);
       sprintf( msg,"If monitoring execution pct (Profiling Program):" );
        _outtext( msg );

        _settextposition(16, 3);
       sprintf( msg,"    Number of P-code statements between profile - " );
        _outtext( msg );

	mode = DISPLAY_ONLY;
	save_window_type = monitor_window_type;
	save_mon_type = monitor_type;
TOF:	
    	ret_val = CWK_Get_Choice( mode, 5, 40, 6, &save_mon_type, 
			monitor_choices, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 6, 25, 6, &type_of_delay, 
			delay_choices, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

    	ret_val = CWK_Get_Choice( mode, 7, 25, 15, &rr_flag, 
			tasking_choices, print_setup_help );
	if ( ret_val == -1 )
		goto LEAVE;

	if ( rr_flag == 1 )
	{
	    choice = 1;
    	    ret_val = CWK_Get_Choice( mode, 8, 56, 5, &choice, 
		    quantum_choices, print_setup_help );
	    rr_nb_max_stmts = atoi( quantum_choices[choice] );
	    if ( ret_val == -1 )
		    goto LEAVE;
	}

	if ( save_mon_type == 1 )
     	{
		ret_val = CWK_Get_Choice( mode, 11, 32, 30, &save_window_type, 
			window_choices, print_setup_help );
		if ( ret_val == -1 )
			goto LEAVE;

    		ret_val = CWK_Get_Choice( mode, 13, 50, 3, &task_step, 
			yes_or_no, print_setup_help );
		if ( ret_val == -1 )
			goto LEAVE;

    		ret_val = CWK_Get_Choice( mode, 14, 50, 3, &step_monitor, 
			yes_or_no, print_setup_help );
		if ( ret_val == -1 )
			goto LEAVE;
	}

	if ( save_mon_type == 2 )
     	{
		choice = 1;
    		ret_val = CWK_Get_Choice( mode, 16, 58, 5, &choice, 
			profile_choices, print_setup_help );
		Exec_Report_Time = atoi( profile_choices[choice] );
		if ( ret_val == -1 )
			goto LEAVE;
	}

	mode = PROCESS_WINDOW;
	goto TOF;

LEAVE:	AVL_DEL_WINDOW( w );

	if ( ( save_mon_type != monitor_type ) ||
	     ( save_window_type != monitor_window_type ) )
	{
		CWK_STOP_MONITORING();
		monitor_type = save_mon_type;
		monitor_window_type = save_window_type;
	}

	if ( monitor_type == 1 )
	{
		CWK_SETUP_WINDOWS();
		print_status(); 
	}

}
