/*
 * Copyright (C) 1985-1992  New York University
 * 
 * This file is part of the Ada/Ed-C system.  See the Ada/Ed README file for
 * warranty (none) and distribution info and also the GNU General Public
 * License for more details.

 */

/* Instruction Codes */

#define I_NOP			     0
#define I_ABORT 		     1
#define I_ABS			     2
#define I_ABS_B 		     2
#define I_ABS_W 		     3
#define I_ABS_L 		     4
#define I_ABS_X 		     5
#define I_ACTIVATE		     6
#define I_ACTIVATE_NEW	             7
#define I_ACTIVATE_NEW_G	     7
#define I_ACTIVATE_NEW_L	     8
#define I_ADD			     9
#define I_ADD_B 		     9
#define I_ADD_W 		     10
#define I_ADD_L 		     11
#define I_ADD_X 		     12
#define I_ADD_IMMEDIATE		     13
#define I_ADD_IMMEDIATE_B	     13
#define I_ADD_IMMEDIATE_W	     14
#define I_ADD_IMMEDIATE_L	     15
#define I_ADD_IMMEDIATE_X	     16
#define I_AND			     17
#define I_ALLOCATE		     18
#define I_ALLOCATE_COPY		     19
#define I_ALLOCATE_COPY_G	     19
#define I_ALLOCATE_COPY_L	     20
#define I_ARRAY_AND		     21
#define I_ARRAY_CATENATE	     22
#define I_ARRAY_MOVE		     23
#define I_ARRAY_NOT		     24
#define I_ARRAY_OR		     25
#define I_ARRAY_SLICE		     26
#define I_ARRAY_XOR		     27
#define I_ATTRIBUTE		     28
#define I_CALL			     29
#define I_CALL_G		     29
#define I_CALL_L		     30
#define I_CALL_PREDEF		     31
#define I_CASE		             32 
#define I_CASE_B		     32
#define I_CASE_W		     33
#define I_CASE_L		     34
#define I_COMPARE		     35
#define I_COMPARE_B		     35
#define I_COMPARE_W		     36
#define I_COMPARE_A		     37
#define I_COMPARE_L		     38
#define I_COMPARE_D		     39
#define I_COMPARE_X		     40
#define I_COMPARE_STRUC 	     41
#define I_CONVERT_TO		     42
#define I_CONVERT_TO_G		     42
#define I_CONVERT_TO_L		     43
#define I_CREATE		     44
#define I_CREATE_B		     44
#define I_CREATE_W		     45
#define I_CREATE_A		     46
#define I_CREATE_L		     47
#define I_CREATE_D		     48
#define I_CREATE_X		     49
#define I_CREATE_COPY                50
#define I_CREATE_COPY_B 	     50
#define I_CREATE_COPY_W 	     51
#define I_CREATE_COPY_A 	     52
#define I_CREATE_COPY_L 	     53
#define I_CREATE_COPY_D 	     54
#define I_CREATE_COPY_X 	     55
#define I_CREATE_COPY_STRUC	     56
#define I_CREATE_TASK		     57
#define I_CREATE_TASK_G 	     57
#define I_CREATE_TASK_L 	     58
#define I_CREATE_STRUC		     59
#define I_CURRENT_TASK		     60
#define I_DEALLOCATE		     61
#define I_DECLARE		     62
#define I_DECLARE_B		     62
#define I_DECLARE_W		     63
#define I_DECLARE_A		     64
#define I_DECLARE_L		     65
#define I_DECLARE_D		     66
#define I_DECLARE_X		     67
#define I_DEREF			     68
#define I_DEREF_B		     68
#define I_DEREF_W		     69
#define I_DEREF_A		     70
#define I_DEREF_L		     71
#define I_DEREF_D		     72
#define I_DEREF_X		     73
#define I_DISCARD_ADDR		     74
#define I_DIV			     75
#define I_DIV_B 		     75
#define I_DIV_W 		     76
#define I_DIV_L 		     77
#define I_DUPLICATE		     78
#define I_DUPLICATE_B		     78
#define I_DUPLICATE_W		     79
#define I_DUPLICATE_A		     80
#define I_DUPLICATE_L		     81
#define I_DUPLICATE_D		     82
#define I_DUPLICATE_X		     83
#define I_END_ACTIVATION	     84
#define I_END_FOR_LOOP		     85
#define I_END_FOR_LOOP_B	     85
#define I_END_FOR_LOOP_W	     86
#define I_END_FOR_LOOP_L	     87
#define I_END_FORREV_LOOP	     88
#define I_END_FORREV_LOOP_B	     88
#define I_END_FORREV_LOOP_W	     89
#define I_END_FORREV_LOOP_L	     90
#define I_END_RENDEZVOUS	     91
#define I_ENTER_BLOCK		     92
#define I_ENTRY_CALL		     93
#define I_FIX_MUL		     94
#define I_FIX_DIV		     95
#define I_FLOAT_ADD		     96
#define I_FLOAT_ADD_L		     96
#define I_FLOAT_ADD_X		     97
#define I_FLOAT_COMPARE		     98
#define I_FLOAT_COMPARE_L	     98
#define I_FLOAT_COMPARE_X	     99
#define I_FLOAT_DIV		     100
#define I_FLOAT_DIV_L		     100
#define I_FLOAT_DIV_X		     101
#define I_FLOAT_MUL		     102
#define I_FLOAT_MUL_L		     102
#define I_FLOAT_MUL_X		     103
#define I_FLOAT_NEG		     104
#define I_FLOAT_NEG_L		     104
#define I_FLOAT_NEG_X		     105
#define I_FLOAT_POW		     106
#define I_FLOAT_POW_L		     106
#define I_FLOAT_POW_X		     107
#define I_FLOAT_SUB		     108
#define I_FLOAT_SUB_L		     108
#define I_FLOAT_SUB_X		     109
#define I_FLOAT_ABS		     110
#define I_FLOAT_ABS_L		     110
#define I_FLOAT_ABS_X		     111
#define I_INDIRECT_MOVE		     112
#define I_INDIRECT_MOVE_B	     112
#define I_INDIRECT_MOVE_W	     113
#define I_INDIRECT_MOVE_A	     114
#define I_INDIRECT_MOVE_L	     115
#define I_INDIRECT_MOVE_D	     116
#define I_INDIRECT_MOVE_X	     117
#define I_INDIRECT_POP		     118
#define I_INDIRECT_POP_B_G	     118
#define I_INDIRECT_POP_B_L	     119
#define I_INDIRECT_POP_W_G	     120
#define I_INDIRECT_POP_W_L	     121
#define I_INDIRECT_POP_A_G	     122
#define I_INDIRECT_POP_A_L	     123
#define I_INDIRECT_POP_L_G	     124
#define I_INDIRECT_POP_L_L	     125
#define I_INDIRECT_POP_D_G	     126
#define I_INDIRECT_POP_D_L	     127
#define I_INDIRECT_POP_X_G	     128
#define I_INDIRECT_POP_X_L	     129
#define I_INSTALL_HANDLER	     130
#define I_IS_EQUAL		     131
#define I_IS_LESS		     132
#define I_IS_GREATER		     133
#define I_IS_LESS_OR_EQUAL	     134
#define I_IS_GREATER_OR_EQUAL	     135
#define I_JUMP			     136
#define I_JUMP_IF_FALSE 	     137
#define I_JUMP_IF_GREATER	     138
#define I_JUMP_IF_GREATER_OR_EQUAL   139
#define I_JUMP_IF_LESS		     140
#define I_JUMP_IF_LESS_OR_EQUAL      141
#define I_JUMP_IF_TRUE		     142
#define I_LEAVE_BLOCK		     143
#define I_LINK_TASKS_DECLARED	     144
#define I_LOAD_EXCEPTION_REGISTER    145
#define I_MEMBERSHIP		     146
#define I_MOD	 		     147
#define I_MOD_B 		     147
#define I_MOD_W 		     148
#define I_MOD_L 		     149
#define I_MOVE			     150
#define I_MOVE_B		     150
#define I_MOVE_W		     151
#define I_MOVE_A		     152
#define I_MOVE_L		     153
#define I_MOVE_D		     154
#define I_MOVE_X		     155
#define I_MUL	 		     156
#define I_MUL_B 		     156
#define I_MUL_W 		     157
#define I_MUL_L 		     158
#define I_NEG	 		     159
#define I_NEG_B 		     159
#define I_NEG_W 		     160
#define I_NEG_L 		     161
#define I_NEG_X 		     162
#define I_NOT			     163
#define I_OR			     164
#define I_POP			     165
#define I_POP_B_G		     165
#define I_POP_B_L		     166
#define I_POP_W_G		     167
#define I_POP_W_L		     168
#define I_POP_A_G		     169
#define I_POP_A_L		     170
#define I_POP_L_G		     171
#define I_POP_L_L		     172
#define I_POP_D_G		     173
#define I_POP_D_L		     174
#define I_POP_X_G		     175
#define I_POP_X_L		     176
#define I_POP_TASKS_DECLARED	     177
#define I_POP_TASKS_DECLARED_G	     177
#define I_POP_TASKS_DECLARED_L	     178
#define I_POW	 		     179
#define I_POW_B 		     179
#define I_POW_W 		     180
#define I_POW_L 		     181
#define I_PUSH			     182
#define I_PUSH_B_G		     182
#define I_PUSH_B_L		     183
#define I_PUSH_W_G		     184
#define I_PUSH_W_L		     185
#define I_PUSH_A_G		     186
#define I_PUSH_A_L		     187
#define I_PUSH_L_G		     188
#define I_PUSH_L_L		     189
#define I_PUSH_D_G		     190
#define I_PUSH_D_L		     191
#define I_PUSH_X_G		     192
#define I_PUSH_X_L		     193
#define I_PUSH_EFFECTIVE_ADDRESS     194
#define I_PUSH_EFFECTIVE_ADDRESS_G   194
#define I_PUSH_EFFECTIVE_ADDRESS_L   195
#define I_PUSH_IMMEDIATE	     196
#define I_PUSH_IMMEDIATE_B	     196
#define I_PUSH_IMMEDIATE_W	     197
#define I_PUSH_IMMEDIATE_A	     198
#define I_PUSH_IMMEDIATE_L	     199
#define I_PUSH_IMMEDIATE_D	     200
#define I_PUSH_IMMEDIATE_X	     201
#define I_QUAL_DISCR		     202
#define I_QUAL_DISCR_G		     202
#define I_QUAL_DISCR_L		     203
#define I_QUAL_INDEX		     204
#define I_QUAL_INDEX_G		     204
#define I_QUAL_INDEX_L		     205
#define I_QUAL_RANGE		     206
#define I_QUAL_RANGE_G		     206
#define I_QUAL_RANGE_L		     207
#define I_QUAL_SUB		     208
#define I_QUAL_SUB_G		     208
#define I_QUAL_SUB_L		     209
#define I_RAISE 		     210
#define I_RAISE_IN_CALLER	     211
#define I_RECORD_MOVE	 	     212
#define I_RECORD_MOVE_G 	     212
#define I_RECORD_MOVE_L 	     213
#define I_REM	 		     214
#define I_REM_B 		     214
#define I_REM_W 		     215
#define I_REM_L 		     216
#define I_RESTORE_STACK_POINTER      217
#define I_RETURN		     218
#define I_RETURN_B		     218
#define I_RETURN_W		     219
#define I_RETURN_A		     220
#define I_RETURN_L		     221
#define I_RETURN_D		     222
#define I_RETURN_X		     223
#define I_RETURN_STRUC		     224
#define I_SAVE_STACK_POINTER	     225
#define I_SELECT		     226
#define I_SELECTIVE_WAIT	     227
#define I_COMPARE_ARRAYS	     228
#define I_STMT			     229
#define I_SUB	 		     230
#define I_SUB_B 		     230
#define I_SUB_W 		     231
#define I_SUB_L 		     232
#define I_SUB_X 		     233
#define I_SUBPROGRAM		     234
#define I_SUBSCRIPT		     235
#define I_TERMINATE		     236
#define I_TEST_EXCEPTION_REGISTER    237
#define I_TIMED_ENTRY_CALL	     238
#define I_TYPE_GLOBAL		     239
#define I_TYPE_LOCAL		     240
#define I_UNCREATE		     241
#define I_UPDATE		     242
#define I_UPDATE_AND_DISCARD	     243
#define I_WAIT			     244
#define I_XOR			     245
#define I_EXIT_BLOCK		     246
#define I_CALL_INTERFACE             247
#define I_CHECK_REC_SUBTYPE	     248
#ifdef GEN
/* pseudo-ops used only by generator */
#define   I_CASE_TABLE                 249
#define   I_LABEL                      250
#define   I_EQUAL                      251
#define   I_END                        252
#define   I_DATA                       253
#endif
