with Text_IO; use Text_IO;
with Semaphore_Package; use Semaphore_Package;
procedure PCBS is

  N: constant Integer := 10;
  B: array(0..N-1) of Integer;
  In_Ptr, Out_Ptr: Integer := 0;
  Count: Integer := 0;

  S: Binary_Semaphore := Init(1);
  Not_Empty, Not_Full: Binary_Semaphore := Init(0);

  task Producer is
    pragma Priority(10);
  end Producer;
  task Consumer1 is
    pragma Priority(7);
  end Consumer1;
  task Consumer2 is
    pragma Priority(7);
  end Consumer2;

  task body Producer is
    I: Integer := 0;
    Local: Integer := 0;
  begin
    loop
      I := I + 1;
      Put_Line("Produce  " & Integer'Image(I));
      if I mod 40 = 0 then delay 1.0; end if;
      if Local = N then Wait(Not_Full); end if;
      B(In_Ptr) := I;
      Wait(S);
      Count := Count + 1;
      Local := Count;
      Signal(S);
      if Local = 1 then Signal(Not_Empty); end if;
      In_Ptr := (In_Ptr + 1) mod N;
    end loop;
  end Producer;

  task body Consumer1 is
    I: Integer;
    Local: Integer := 0;
  begin
    loop
      if Local = 0 then Wait(Not_Empty); end if;
      I := B(Out_Ptr);
      Wait(S);
      Count := Count - 1;
      Local := Count;
      Signal(S);
      if Local = N-1 then Signal(Not_Full); end if;
      Out_Ptr := (Out_Ptr + 1) mod N;
      Put_Line("Consume 1 " & Integer'Image(I));
    end loop;
  end Consumer1;

  task body Consumer2 is
    I: Integer;
    Local: Integer := 0;
  begin
    loop
      if Local = 0 then Wait(Not_Empty); end if;
      I := B(Out_Ptr);
      Wait(S);
      Count := Count - 1;
      Local := Count;
      Signal(S);
      if Local = N-1 then Signal(Not_Full); end if;
      Out_Ptr := (Out_Ptr + 1) mod N;
      Put_Line("Consume 2 " & Integer'Image(I));
    end loop;
  end Consumer2;

begin
  null;
end PCBS;
