unit global;

{  Global definitions }

interface

const
  nkw     = 31;    { number of reserved keywords }
  alng    = 10;    { length of an "alfa" string }
  llng    = 100;   { length of an input line }
  kmax    = 12;    { maximum digits in a number }
  tmax    = 50;    { maximum entries in symbol table }
  bmax    = 10;    { maximum number of blocks }
  amax    = 4;     { maximum number of arrays }
  cmax    = 200;   { maximum number of code instructions }
  lmax    = 4;     { maximum levels of nesting }
  smax    = 150;   { maximum total length of strings }
  stmax   = 1400;  { maximum total length of stack }
  stkincr = 200;   { stack increment for each process }
  pmax    = 3;     { maximum number of processes }
  emax    = 5;     { maximum number of entries }
  initmax = 5;     { maximum variables to initialize }

type
  symbol=
    (intcon, charcon, strng,
     notsy, plus, minus, times, idiv, imod, andsy, orsy,
     eql, neq, gtr, geq, lss, leq,
     lparent, rparent, comma, semicolon, period, colon, becomes,
     constsy, typesy, proceduresy, arraysy, ident,
     beginsy, ifsy, whilesy, forsy,
     endsy, elsesy, ofsy, dosy, tosy, thensy,
     issy, insy, loopsy, tasksy, bodysy, terminate,
     elsif, exitsy, when, outsy, acceptsy, selectsy, arrow,
     nullsy, pragmasy);

  object   = (konstant, variable, type1, prozedure, funktion, task);
  parmmode = (noparm,   inparm,   outparm);

  types    = (notyp, ints,  bools, chars, arrays);
  er       = (erid,  ertyp, erkey, erpun, erpar,
              ernf,  erdup, erch,  ersh,  erln);

  ptype    = 0..pmax;
  alfa     = packed array[1..alng] of char;
  symset   = set of symbol;
  typset   = set of types;

  item=             { description of an expression in the compiler }
    record          { fields as in tab }
      typ: types;
      ref: integer;
    end;

  order=            { byte code: instruction + two parameters }
    packed record
      f: byte;
      x: byte;
      y: integer;
    end;

var
  inputfile: string[20];     { input file name }
  entries:   integer;        { number of entries }
  curtask:   integer;        { current task }
  elabs:     integer;        { number of tasks to elaborate }
  inits:     integer;        { number of variables to initialize }

  display: array[0..lmax] of integer;
                             { reflects static links for addressing }

  tab: array[0..tmax] of     { symbol table }
         packed record
           name:   alfa;     { symbol name }
           link:   integer;  { link to previous symbol in block }
           obj:    object;   { variable, procedure, etc. }
           typ:    types;    { integer, char, etc. }
           ref:    integer;  { reference to block or array table }
           normal: boolean;  { false = indirect reference "out" parm }
           lev:    0..lmax;  { static level: 0 = predefined, 1 = main }
           adr:    integer;  { constant = value, type = size,
                              variable = offset on stack }
         end;

  atab: array[1..amax] of    { array table }
          packed record
            inxtyp: types;   { index type }
            eltyp:  types;   { element type }
            low:    integer; { lower index }
            high:   integer; { higher index }
            elsize: integer; { size of one element }
            size:   integer; { total size of array }
          end;

  btab: array[1..bmax] of     { block table }
          packed record
            last:    integer; { last identifier }
            lastpar: integer; { last parameter }
            psize:   integer; { size of activ. record + parms }
            vsize:   integer; { psize + local variables }
          end;

  inittab: array[1..initmax] of { initialization table }
          packed record
            addr:  integer;     { symbol table address }
            value: integer;     { initial value }
          end;

  elabtab: array[1..pmax] of integer; { elaboration table }

  stab: packed array[0..smax] of char; { string table }

  code: array[0..cmax] of order;  { code table }

  entry: array[0..emax] of     { entry table }
          record
            taskid:  integer;  { task containing the entry }
            name:    alfa;     { entry name }
            open:    integer;  { pc of accept statement }
            waiting: ptype;    { first waiting process or
                                 process in rendezvous }
            p1mode:  parmmode; { first parameter mode }
            p2mode:  parmmode; { second parameter mode }
            p1loc:   integer;  { first parameter location }
            p2loc:   integer   { second parameter location }
          end;

const
  stantyps: typset = [notyp, ints, bools, chars];

implementation
end.