/* grafsupp.h

Header file to accompany the functions in grafsupp.c,
which are supplemental to those in Borland Turbo C.
This header file defines constants, etc. which make it possible
for the user to think in terms of coordinates which are natural
for the variables to be plotted and which are independent of the graphics
mode in operation (CGA, EGA, VGA, etc).
We call these coordinates "generic" coordinates, which always
lie between 0 and 1, and "user" coordinates, which lie in whatever
range the user wants.

Jon Ahlquist, 26 June 1988, 13 Jan 1990.

Copyright 1990 by Jon Ahlquist, Department of Meteorology B-161,
Florida State University, Tallahassee, Florida 32306-3034, USA.
Telephone: (904) 644-1558.
Telnet address: ahlquist@metsat.met.fsu.edu (ahlquist@128.186.5.2)

This software may be freely copied without charge.
Copyright is made to prevent anyone from trying to impose restrictions
on this software.
All software and documentation is provided "as is" without warranty
of any kind.

Development of this material was sponsored by NSF grant ATM-8714674.
*/

/* Import global variables that ar defined in grafsupp.c */

/* Declare global variables set by scale(). */

extern
float _xscale,     _xoffset,     _yscale,     _yoffset,
      _xscale_gen, _xoffset_gen, _yscale_gen, _yoffset_gen,
      _X_left, _X_right, _Y_bottom, _Y_top,
      pixel_aspect_ratio;

extern
int   XX_max, YY_max, XX_width;



/* 
Define the transformation equations between the user's coordinates (x,y)
and the pixel coordinates (XX,YY) of the particular graphics mode for which
the user's graphics board is set. Also define the transformation
equations between generic screen coordinates (X,Y), where both X and Y
range from 0 to 1, and the pixel coordinates (XG,YG) of the particular
graphics mode for which the user's graphics board is set.
The values for
_xscale,     _xoffset,     _yscale,         _yoffset,
_xscale_gen, _xoffset_gen, _yscale_gen, and _yoffset_gen
are determined by function scale(), which was written by Jon Ahlquist.
*/

#define XX(x) ((int) ((x)*_xscale     + _xoffset))
#define YY(y) ((int) ((y)*_yscale     + _yoffset))
#define XG(X) ((int) ((X)*_xscale_gen + _xoffset_gen))
#define YG(Y) ((int) ((Y)*_yscale_gen + _yoffset_gen))

/**************************
Define function prototypes.
**************************/

void scale(float X_left,        float X_right,
           float Y_bottom,      float Y_top,

           float x_left_user,   float x_right_user,
           float y_bottom_user, float y_top_user);

/* After initgraph() and then scale() have been called,
the following functions can be called. */

void load_array(float *x, int n, float xmin, float xmax);
void draw_perimeter(int n_major_x, int n_minor_x,
                    int n_major_y, int n_minor_y);
void label_plot(char *title, char *xlabel, char *ylabel);
void plot_curve(float *x, float *y, int n);