/* edit.c - string editor, 1991 Mike McCombs */

/*////////////////////////// History ///////////////////////////////////*/
/* 09/24/91  McCombs  - moved it all to the module edit.c               */
/* 03/14/91  McCombs  - wrote all the functions as part of arjmenu.c    */
/*//////////////////////////////////////////////////////////////////////*/

#include <conio.h>
#include "arjopt.h"  /* or whatever file include key definitions */
/* #include "edit.h"  - use if not defined elsewhere */

unsigned getkey(void) /* read keyboard input */
{
	unsigned key;

	if((key = getch()) == 0)
	key = getch() << 8;
	return(key);
}

int next_word(char *str, int ndx)  /* advance one word */
{
	int len;

	len = strlen(str);
	while(ndx < len && str[ndx] != ' ')
	ndx++;
	while(ndx < len && str[ndx] == ' ')
	ndx++;
	if(ndx == len)
	{
	while(ndx >= 0 && str[ndx] == ' ')
		ndx--;
	while(ndx >= 0 && str[ndx] != ' ')
		ndx--;
	ndx++;
	}
	return(ndx);
}

int prev_word(char *str, int ndx)  /* go back one word */
{
	int len;

	len = strlen(str);
	while(ndx && str[ndx] != ' ')
	ndx--;
	while(ndx && str[ndx] == ' ')
	ndx--;
	while(ndx >= 0 && str[ndx] != ' ')
	ndx--;
	while((ndx < len && str[ndx] == ' ') || (ndx < 0))
	ndx++;

	if(ndx == len)
	ndx = 0;
	return(ndx);
}

int delete_char(char *str, int ndx) /* character delete */
{
	int ndx_start;

	ndx_start = ndx;

	while(str[ndx])
	{
	str[ndx] = str[ndx + 1];
	ndx++;
	}
	return(ndx_start);
}

int insert_char(char *str, int ndx, char c) /* character insertion */
{
	int i;

	for(i = strlen(str) - 1; i > ndx; i--)
	str[i] = str[i - 1];

	str[ndx] = c;
	return(++ndx);
}

int editline(char *str) /* edit user input as displayed */
{
	unsigned doneflag = 0;
	int insertflag = 1, index = 0;
	int key, len, i;
	struct text_info strpos;

	/* display blank line */
	len = strlen(str);
	str[len] = '\0';

	/* reposition cursor and wait for key stroke */
	gettextinfo(&strpos);
	while(kbhit())   /* flush keyboard buffer */
	getch();

	/* sort and act on key stroke */
	while(!doneflag)
	{
	gotoxy(strpos.curx, strpos.cury);
	cprintf("%s", str);
	gotoxy(strpos.curx + index, strpos.cury);

	if(insertflag)
		_setcursortype(_NORMALCURSOR);
	else
		_setcursortype(_SOLIDCURSOR);

	key = getkey();
	switch(key)
	{
		case KEY_LEFT:
			if(index)
				index--;
			break;
		case KEY_RIGHT:
			if(index < len)
				index++;
			break;
		case KEY_ESCAPE:
			str[0] = '\30';
			str[1] = '\0';
			doneflag = key;
			break;
		case KEY_END:
			for(index = len - 1; str[index] == ' ' && index; index--)
				{;}
			if(index && index < len - 1)
				index++;
			break;
		case KEY_BACKSPACE:
			if(index)
			{
				index--;
				delete_char(str, index);
				str[len - 1] = ' ';
			}
			break;
		case KEY_INSERT:
			insertflag ^= 1;
			break;
		case KEY_DELETE:
			delete_char(str, index);
			str[len - 1] = ' ';
			break;
		case KEY_ENTER:
			doneflag = key;
			break;
		case KEY_HOME:
			index = 0;
			break;
		default:
			if(key >= ' ' && key < 255)
			{
				if(insertflag)
					insert_char(str, index, (char)key);
				else
					str[index] = (char)key;
				if(index < len - 1)
					index++;
			}
			else
				printf("\7");
			break;
	}
	str[len] = '\0';
	}
	/* strip terminal spaces */
	len = strlen(str);
	for(i = len - 1; str[i] == ' '; i--)
	str[i] = '\0';
	_setcursortype(_NORMALCURSOR);

	return(doneflag);
}

