/* globber.h - combination of wildfile.h and filmatch.h by John Kercheval */
/* with buf_upper() from Robert Jung - assembled 1992 Mike McCombs        */
/* I recommend seeing WILDF1xx.[archive] by Kerceval for a full           */
/* explanation                                                            */


/*///////////////////// Function Listing /////////////////////////////////*/
/* void splitpath( FileInfo *ff ) parse path from entries in arguments    */
/* int matche_after_star (register char *pattern, register char *text)    */
/*         recursively call matche() with final segment of PATTERN and    */
/*         of TEXT                                                        */
/* int matche(register char *pattern, register char *text) a shell to     */
/*         matche() to return only BOOLEAN values                         */
/* void buf_upper(char *s, unsigned n) fast string upper casing by Jung   */
/* BOOLEAN match (char *pattern, char *text)  SEE BOX BELOW               */
/* BOOLEAN is_pattern (char *pattern) returns true if special wildcard    */
/*         characters are found                                           */
/* BOOLEAN is_valid_pattern (char *pattern, int *error_type) returns true */
/*         if pattern is legit - false otherwise                          */
/* BOOLEAN find_firstfile( FileInfo *ff ) findfirst() with globbed params */
/* BOOLEAN find_nextfile( FileInfo *ff ) findnext() with globbed params   */
/*////////////////////////////////////////////////////////////////////////*/

/* needed defines */
#ifndef BOOLEAN
# define BOOLEAN int
# define TRUE 1
# define FALSE 0
#endif

# include <dir.h>

/* structure member defines */
# define info ffblk
# define attributes ff_attrib
# define timestamp ff_ftime
# define datestamp ff_fdate
# define size ff_fsize
# define name ff_name
# define findfirst(n, a, s) _dos_findfirst(n, s, a)
# define findnext _dos_findnext

/* match defines */
#define MATCH_PATTERN  6    /* bad pattern */
#define MATCH_LITERAL  5    /* match failure on literal match */
#define MATCH_RANGE    4    /* match failure on [..] construct */
#define MATCH_ABORT    3    /* premature end of text string */
#define MATCH_END      2    /* premature end of pattern string */
#define MATCH_VALID    1    /* valid match */

/* pattern defines */
#define PATTERN_VALID  0    /* valid pattern */
#define PATTERN_ESC   -1    /* literal escape at end of pattern */
#define PATTERN_RANGE -2    /* malformed range in [..] construct */
#define PATTERN_CLOSE -3    /* no end bracket in [..] construct */
#define PATTERN_EMPTY -4    /* [..] contstruct is empty */

#define DOT_LAST 0x01   /* set status byte if last char in pattern is '.' */

struct file_info_struct {

	/* thest elements should be set before the call to find_firstfile() */
	 char file_pattern[2*MAXPATH+1];     /* the original file pattern */
	 char file_attributes;               /* the wanted file attributes */

	 /* these elements are filled by find_firstfile() and find_nextfile() */
	 char file_path[MAXPATH+1];          /* the lead portion of the path */
	 struct info file;                   /* the file block */
	 unsigned char status;               /* internal status information */
};

typedef struct file_info_struct FileInfo;

void splitpath( FileInfo *ff );
int matche_after_star (register char *pattern, register char *text);
int matche(register char *pattern, register char *text);
void buf_upper(char *s, unsigned n);
BOOLEAN match (char *pattern, char *text);
BOOLEAN is_pattern (char *pattern);
BOOLEAN is_valid_pattern (char *pattern, int *error_type);
BOOLEAN find_firstfile( FileInfo *ff );
BOOLEAN find_nextfile( FileInfo *ff );

/*////////////////// What match() does (from John Kercheval) ///////////////*/
/*  Match the pattern PATTERN against the string TEXT;                      */
/*                                                                          */
/*  returns MATCH_VALID if pattern matches, or an errorcode as follows      */
/*  otherwise:                                                              */
/*                                                                          */
/*            MATCH_PATTERN  - bad pattern                                  */
/*            MATCH_RANGE    - match failure on [..] construct              */
/*            MATCH_ABORT    - premature end of text string                 */
/*            MATCH_END      - premature end of pattern string              */
/*            MATCH_VALID    - valid match                                  */
/*                                                                          */
/*                                                                          */
/*  A match means the entire string TEXT is used up in matching.            */
/*                                                                          */
/*  In the pattern string:                                                  */
/*       `*' matches any sequence of characters (zero or more)              */
/*       `?' matches any character                                          */
/*       [SET] matches any character in the specified set,                  */
/*       [!SET] or [^SET] matches any character not in the specified set.   */
/*       \ is allowed within a set to escape a character like ']' or '-'    */
/*                                                                          */
/*  A set is composed of characters or ranges; a range looks like           */
/*  character hyphen character (as in 0-9 or A-Z).  [0-9a-zA-Z_] is the     */
/*  minimal set of characters allowed in the [..] pattern construct.        */
/*  Other characters are allowed (ie. 8 bit characters) if your system      */
/*  will support them.                                                      */
/*                                                                          */
/*  To suppress the special syntactic significance of any of `[]*?!^-\',    */
/*  within a [..] construct and match the character exactly, precede it     */
/*  with a `\'.                                                             */
/*                                                                          */
/*//////////////////////////////////////////////////////////////////////////*/


