         PAGE  60,132
         TITLE MIRDIR - Directory Mirror program
;        SUBTTL  General program description and use of common storage
; ----------------------------------------------------------------------------;
;        MIRDIR - Enter identical directory on another drive as current direct;
; ----------------------------------------------------------------------------;
;   MIRDIR 1.0  PCDATA TOOLKIT Copyright (c) 1990 Ziff Communications Co.    ;
;                   PC Magazine  Wolfgang Stiller                            ;
;                                                                             ;
;-----------------------------------------------------------------------------;

; Purpose:                                                                    ;
;  To "mirror" the directory structure from one disk to another disk.         ;
;  MIRDIR will determine the current directory name, and attempt to           ;
;  change to, or create the same directory on the specified disk.             ;
; ----------------------------------------------------------------------------;
;Format:                                                                      ;
;                                                                             ;
;MIRDIR d:                                                                    ;
;                                                                             ;
;   d: Specifies the drive on which the current directory is to be mirrored.  ;
;                                                                             ;
; ----------------------------------------------------------------------------;
;Remarks:                                                                     ;
;                                                                             ;
;    "Mirroring" means to change to the same directory on another drive       ;
;    as the current directory on the default drive. If this directory         ;
;    does not exist, then MIRDIR will attempt to create the directory.        ;
;    MIRDIR will only create a new directory if the parent for the            ;
;    missing directory exists. In other words if the current directory        ;
;    name is: "A\B\C", MIRDIR will fail if the target disk does not have      ;
;    a directory named "A\B" or one named "A\B\C".  If MIRDIR is used         ;
;    with program Xall, this condition will automatically be satisfied,       ;
;    if executed from the root directory.                                     ;
;                                                                             ;
; MIRDIR will return the following DOS error levels:                          ;
;   128 (40h) if fatal error on starting such as bad syntax.                  ;
;    32 (20h) indicates MIRDIR unable to mirror the directory. This means it  ;
;             attempted to create the directory and failed.                   ;
;    04       Directory was not found on target volume, but MIRDIR created it.;
;    00       Normal completion.                                              ;
;                                                                             ;
; ----------------------------------------------------------------------------;

;---------------------------------------------------------------;
; Constants:                                                    ;
;---------------------------------------------------------------;
BOX     EQU    254                        ;Small box character code
CR      EQU    0Dh
LF      EQU    0Ah
CRLF    EQU    0A0Dh                      ;Carriage return line feed.

CSEG    SEGMENT
        ASSUME  CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

        SUBTTL  Main program
;******************************************************************************;
;**   Main program begins here -MIRDIR-                                      **;
;******************************************************************************;
        ORG     100H                      ; This is a .COM type program
MIRDIR:
        CALL    Parse_parms_Print_Header  ;Parse cmdline paramters + prnt header
                                          ;Set mirror drive letter in path strng
        XOR     BP,BP                     ;Set zero as highest return code
        CALL    Get_Current_Directory     ;Get name of current directory
        CALL    Mirror_Current_Directory  ;Now change other drive to same dir
        MOV     AX,BP                     ;BP contains highest return code
        MOV     AH,4Ch                    ;   terminate with  return code
        INT     21h

;---------------------------------------------------------------------------;
; GET CURRENT DIRECTORY                                                     ;
;   Ask DOS for current directory string. Store it in a substring of        ;
;   Mir_Directory.                                                          ;
;---------------------------------------------------------------------------;
Get_Current_Directory:                    ;Determine current directory
        MOV     SI,offset Current_Path    ;Place to store original directory
        XOR     DL,DL                     ;Zero DL in order to use default drive
        MOV     AH,47h                    ;Get current directory (path) func
        INT     21h
        RET


;---------------------------------------------------------------------------;
; MIRROR CURRENT DIRECTORY                                                  ;
;   Try to change to the directory on users specified "Mirror_drive" to     ;
;   match the current directory which we stored in substring of             ;
;   Mir_Directory. If this fails, we will attempt to create this            ;
;   directory and then change to that directory.                            ;
;---------------------------------------------------------------------------;
Mirror_Current_Directory:
; 1) Attempt change to same directory as on current drive
        MOV     DX, offset Mir_Directory  ;Directory name including drive.
        MOV     AH,3Bh                    ;Set current directory function
        INT     21h
        JC      Invalid_path              ;IF function failed
        RET                               ;It worked! we are all done.
Invalid_Path:                             ;Change dir failed so try MKdir
; 2) If change failed then try to create the missing directory
        MOV     AH,39h                    ;DOS create directory function
                                          ;DX already points to directory string
        INT     21h                       ;Create new directory
        JC      Create_Dir_Failed         ;If creation of new directory failed..
; 3) Now change over to the newly created directory
        MOV     AH,3Bh                    ;Set current directory function
        INT     21h                       ;Set to the newly created directory
        JC      Create_Dir_Failed         ;IF failure (should never happen)
                                          ;It worked! Tell user we created dirct
        MOV     BP,04h                    ;Set error level for "create worked"
        MOV     DX, offset Dir_create_Msg ;beginning of "Create" message
        MOV     CX,13                     ;Number of chars in message
        CALL    Display_Directory_Name    ;Display message + directory name
        RET
Create_Dir_Failed:
        MOV     DX, offset Bad_create_Msg ;beginning of "Create failed" message
        MOV     CX,19                     ;Number of chars in message
        CALL    Display_Directory_Name    ;Display message + directory name

        MOV     DX,OFFSET Create_detail_Msg  ;Give user details of failure
        MOV     AH,09h                    ;DOS display string function
        INT     21H

; Produce a beep to alert the user:  (use  BIOS TTY func to write an ASCII BELL)
        MOV     AX,0E07H                  ;BIOS func (0Eh) to write (07H) beep
        XOR     BH,BH                     ;Select page zero for output
        INT     10H                       ;BIOS video function (0Eh=write char)

; Wait for user to hit any key
        XOR     AX,AX
        INT     16h                       ;Wait for user to hit a key

        MOV     BP,20h                    ;Error level code for batch file use
        RET

;---------------------------------------------------------------------------;
; DISPLAY DIRECTORY NAME                                                    ;
;   Display message pointed to by DX of length CX and the directory and     ;
;   drive string in Mir_Directory.                                          ;
;---------------------------------------------------------------------------;
Display_Directory_Name:
        MOV     AH,40h                    ;DOS Write func
        MOV     BX,1                      ;Handle for std output device
        INT     21h                       ;Write Start of message
;   Scan the string in Mir_Directory to determine its length:
        CLD                               ;Forward Scan
        MOV     DI,OFFSET Mir_Directory   ;Location of Mir_Directory
        MOV     DX,DI                     ;Saved copy of directory start
        XOR     AX,AX                     ;Scan for zero termination of string
        MOV     CX,67                     ;Scan up to 67 characters
        REPNE   SCASB                     ;Find 1st zero byte
        SUB     DI,DX                     ;Length of directory string
        MOV     CX,DI                     ;Characters to display in dir string
;DX = start of dir strng, CX = # of chars in string
        MOV     AH,40h                    ;DOS Write func
        INT     21h                       ;Display the actual directory string
        MOV     DX,OFFSET CRLF_str        ;Prepare to put out carriage ret + LF
        MOV     CX,2                      ;Print 2 characters
        MOV     AH,40h                    ;DOS Write func
        INT     21h
        RET

        SUBTTL  Initialization code
        PAGE
; ----------------------------------------------------------------------------;
; Initialization code - parse parms + place drive letter in path string       ;
; ----------------------------------------------------------------------------;
Parse_parms_Print_Header:                 ;Parse input parameters + print header
        MOV     SI,80H                    ;Parameter area in PSP
        MOV     CL,[SI]                   ;Get # of chars in input parm
        XOR     CH,CH                     ;Clear upper byte of char count
        OR      CL,CL                     ;Check for 0 chars (NO INPUT)
        MOV     DX, OFFSET Missing_D_Msg  ;Prepare syntax description message
        JZ      ERR_EXIT                  ;IF NO PARMS, give user correct syntax
        INC     SI                        ;Point to 1st char
        CLD                               ;Forward direction

DEL_SPACES:
        LODSB                             ;Get byte at DS:SI and inc SI
        CMP     AL,' '                    ;Is it a space?
        JNE     Check_for_drive           ;If not we have something..
        LOOP    DEL_SPACES                ;CONT CHECKING UNTIL LAST CHAR
ERR_EXIT:
        MOV     AH,09h                    ;DOS display string function
        INT     21H

; Produce a beep to alert the user:  (use  BIOS TTY func to write an ASCII BELL)
        MOV     AX,0E07H                  ;BIOS func (0Eh) to write (07H) beep
        XOR     BH,BH                     ;Select page zero for output
        INT     10H                       ;BIOS video function (0Eh=write char)

; Wait for user to hit any key
        XOR     AX,AX
        INT     16h                       ;Wait for user to hit a key

        MOV     DX, OFFSET Syntax_msg     ;Prepare syntax description message
        MOV     AH,09h                    ;DOS display string function
        INT     21H
        MOV     AX,4C80h                  ;   terminate with 40h return code
        INT     21h
;---------------------------------------------------------------------------;
; Conventions for command line parsing:                                     ;
;   SI points to next char to be checked in the parm field at DS:80         ;
;   CX is count of characters left to be scanned                            ;
;---------------------------------------------------------------------------;
Check_for_drive:
        CMP     BYTE PTR [SI],':'         ;Check for presence of drive spec
        JNZ     ERR_Exit                  ;Give user some help...
        AND     AL,5Fh                    ;Capitalize drive letter
        MOV     Mir_Drive,AL              ;Save a copy of drive letter
        MOV     DX,OFFSET Start_Msg       ;Initial message
        MOV     AH,09H                    ;DOS display string function
        INT     21H
        RET

        SUBTTL  Definition of Data structures
        PAGE
;******************************************************************************;
;**   Definition of Data areas follow                                        **;
;******************************************************************************;
Root_dir      DB  '\',0                   ;Zero terminated root dir string
Mir_directory Label BYTE                  ;Same as location "Mir_Drive"
Mir_Drive     DB   'A:'                   ;Name of drive to be mirrored
              DB   '\'                    ;Force 1st char directry strng to '\'
Current_Path  DB   64 DUP (0)             ;Save area to restore original path

Start_MSG     DB  CR,LF,"MIRDIR 1.0 ",BOX," PCDATA TOOLKIT (c) 1990"
              DB  " Ziff Communications Co.",CR,LF
              DB  "PC Magazine ",BOX," Wolfgang Stiller",CR,LF,"$"
Missing_D_Msg DB  'The drive letter of the target drive is missing.',CR,LF
              DB  'It should be entered with a colon.',CR,LF
              DB  'Example:',CR,LF
              DB  '          MIRDIR A:',CR,LF
              DB  'will mirror the current directory on drive A.',CR,LF,Lf
              DB  'Please hit a key - ',CR,LF,LF,'$'
Syntax_Msg    DB  "MIRDIR 1.0 ",BOX," PCDATA TOOLKIT Copyright (c) 1990"
              DB  " Ziff Communications Co.",CR,LF
              DB  "PC Magazine ",BOX," Wolfgang Stiller",CR,LF,CR,LF
              DB  'Syntax is: MIRDIR d:',CR,LF,LF
              DB  'd:  is the drive upon which MIRDIR will "mirror" '
              DB  'the current directory.',CR,LF
              DB  '    MIRDIR will change to a directory on drive d: '
              DB  'which matches the',CR,LF
              DB  '    current directory. If not found, it will try to '
              DB  'create the directory.'
CRLF_str      DB   CR,LF,'$'
Bad_Create_Msg    DB 'Create failed for: '
Dir_Create_Msg    DB 'Created dir: '
Create_Detail_Msg DB CR,LF,'The create probably failed due to 1 of 2 reasons:'
                  DB CR,LF
                  DB ' 1) There is a insufficient space on the target disk'
                  DB CR,LF,'     or',CR,LF
                  DB ' 2) The parent directory did not exist. For example,'
                  DB CR,LF
                  DB '    to create directory "\A\B", directory "\A" must '
                  DB ' first exist.'
                  DB CR,LF,LF,'Please hit a key',CR,LF,'$'
User_file_spec EQU  $                ;User specified file spec to check
CSEG    EndS
        END     MIRDIR
