	title	'RES86 DISASSEMBLER'
	page	60,132
;
;	last edit 02/10/85 wde
;	2/10/85 2.3b fix goof in read .ctl funct
;	fix flow indic semic test,repair 8080 sym lookup
;	fix sym type write bug
;	1/17 2.3a add fixes from b kendall

;	3/21/85 3.0 convert to masm format for ms-dos systems by Craig Derouen


code	segment byte public

	extrn	cntenb:byte,opdtyp:byte,quiflg:byte,segflg:byte,segmsk:byte
	extrn	segsho:byte,sdflg:byte,trmflg:byte,typndx:byte,wfiflg:byte
	extrn	wrtflg:byte,xcsw:byte,adb:byte,strcnt:byte,symtyp:byte

	extrn	ascbld:word,cofset:word,ctlbas:word,ctltop:word,curofs:word
	extrn	curpar:word,dmpcnt:word,dmpend:word,dmpstt:word,docend:word
	extrn	doctbl:word,ecnt:word,fndadd:word,fndpc:word,hiload:word
	extrn	insloc:word,lastwd:word,liscnt:word,mcbsiz:word,ofsptr:word
	extrn	nrsegs:word,nxtctl:word,pcntr:word,rplptr:word,segsiz:word
	extrn	stack:word,symtp:word,xcptr:word,cmdbuf:word
	extrn	segnam:word,mcbbas:word,fake_comtbl:word

	extrn	addfn:near,bdos:near,cmentr:near,cmkill:near
	extrn	creatf:near,cstbl:near,crlf:near,dline:near
	extrn	dcrlf:near,fclose:near,fopen:near,gtcmd:near,gtval:near
	extrn	hexl:near,hexr:near,ifasci:near,initbl:near
	extrn	keychk:near,lita86:near,litall:near,litcmd:near,litctl:near
	extrn	litdoc:near,litsym:near,lngth:near,locsym:near,prntde:near
	extrn	prtstr:near,prspc:near,prword:near,pstar:near,pstrg:near
	extrn	rdfchr:near,semic:near,symbas:near,symluk:near
	extrn	tabc:near,typech:near,wtfchr:near,xo:near,xo0:near,flushf:near
	extrn	cmpstr:near,pstg:near

	public	start,hsym,nwln0,delim,cmerr,nxcmd

	public	fcb,tbuf

; dummy publics for symbol file

	public	entry,ardnam,restrt,l01cf,funlp,fndfun,segonl,fcttbl,fctend
	public	deliok,cmhelp,cmtrim,trmof,cmpurg,l02c9,cmprlg,l02df,pfnlp
	public	nofnam,pnmdun,l031d,prlglp,l032c,l033d,l034b,l0362,l0380,l0394
	public	nodisp,sgreqs,updseg,segmch,segmtb,cmqiet,l03b2,cmdump,l0411
	public	l0418,dump0,dump1,dump3,dmphdr,cntdmp,dump4,dmpln,wdspc1
	public	wdspc2,wdspc3,dmpasc,period,chrctr,wdspc4,lcmplt,sducnt,l04e8
	public	l04ef,dusymt,frmbgn,frmsym,agnsym,l051a,spit,spit1,spitcr,spcrlf
	public	spcry,iecnt,prntos,gfnam,l056a,l057d,nodriv,mvnfld
	public	eatfld,l05b6,padfld,cmatmt,cmbld,cmlist,list1,list2,list3
	public	tenl,contl,flagck,builda,loop8,follow,morel,nwln,ncsemi,cntcmt
	public	ntbksl,morel1,morel2,ncmt,cml15,l06fd,ckbmd,ckhmd,ckwmd,badmd,ictl
	public	slicnt,l0762,l0776,l077d,dsmode,wmode,stpln,hmode,bmode,bmode1
	public	nprtc,morinv,ltlf,mvup,trysym,nstpln,l0864,nxinv,conasc,morasc
	public	l08ac,yet,still,lastqt,fnlqt,qtb,cmstts,nodoct,l0984,sgplp
	public	usdseg,sgpen,prwval,cmfind,l09c6,l09d1,prevf,nyet
	public	cmeof,l0a35,cmread,rdaprv,wntall,lodall,chgtyp,ntlall,symffd
	public	l0a8a,wntcmd,lodcmd,cmdlds,modofs,cmhlp,cmhmlp,set_dmablk
	public	mrqok,l0ac4,l0adc,l0aec,doclod,gotdoc,lodsym,comrd_lp
	public	ldsym2,loddoc,lddoc2,ldasfl,skppre,l0b6c,drdsk1,lpasld,ldassp
	public	hexbin,l0ba3,l0ba8,l0baf,l0bb5,erstbl,etlp1,etlp2,cmsave
	public	savok,allsav,nosdoc,nossym,havctl,ntsall,ntssym,ntsctl,symsav
	public	l0bf4,l0bf7,sdskp1,l0c0c,oufend,ntsdoc,outadr,sava86,savdoc
	public	rrqerr,l0d20,cmctl,l0d45,l0d4f,l0d5a,enterc,entrc2,entrc4
	public	l0d84,l0dba,l0dc6,cltrck,ctlck2,cltrrt,l0bf5,entrc5,entrc7
	public	entrc8,l0e34,ctlook,ctlk2,l0e4s,l0e5c,l0e48,ctlk4,l0e65,clist0
	public	clist,clist2,l0e87,l0e99,skclis,savctl,svctl0,l0ebf,l0ee6
	public	lodctl,ctlfnd,l0ef7,l0efd,l0f0b,l0f23,l0f30,cmcmnt,cmnt0,cmnt2
	public	cmnt1,l0f52,l0f5d,l0f71,l0f7d,comchk,l0fa6,l0fb2,l0fc3,l0fce
	public	l0fd4,l0fd8,l0fec,l0ffa,l100b,l1015,l1023,l1041,l104c,cmusec
	public	l10ce,ustok,uaset,l10ef,l111c,l1151,l1152,good_vers,good_mem

	assume cs:code,ds:code

	org	5ch
fcb	db	36 dup (?)
tbuf	db	128 dup(?)	;that takes care of the first page


symmax	equ	9		;max chars in symbol
tab	equ	9
cr	equ	0dh
lf	equ	0ah
initlcnt equ	20

;
	org	100h

	if2
	%out	Compiling in PASS 2 finally!
	endif

start:
	mov	ah,30h
	int	21h
	cmp	al,2
	jae	good_vers
	mov	dx,offset bad_vers
	mov	ah,9
	int	21h
	int	20h			; back to DOS!

bad_vers db	cr,lf,7,'Wrong version of DOS! Must be 2.0 or higher$'

good_vers:
; First thing is to de-allocate memory so we can grab portions at a time.
	mov	bx,offset symbas	; the end of program
	sub	bx,100h			; start of program
	mov	cl,4
	shr	bx,cl			; convert to paras!

; Now add about 10k for symbol table
	add	bx,640			; 10K in paras
	mov	ah,4ah
;	int	21h			; here we go!
;	jnc	good_mem		; we have enough!
;	mov	ah,9
;	mov	dx,offset memory_fail
;	int	21h
;	mov	ax,4cffh
;	int	21h			; exit with a -1
;
;memory_fail db	cr,lf,7,'Not enough memory to run!$'

good_mem:

	call	entry
	db	'RESOURCE by Ward Christensen',cr,lf
	db	'Transl. to 8086 by Larry Etienne',cr,lf
	db	'Converted 8086 MS-DOS Ver. 3.0',cr,lf
	db	'by C.Derouen (3-26-85)',cr,lf
	db	'Copyright 1980$'
;
entry:	pop	dx
	mov	ax,ds
	cli
	mov	ss,ax
	mov	sp,offset stack
	sti
	mov	es,ax			;start = data seg
	push	cs
	pop	ds			;segment for signon msg
	mov	ah,9
	call	bdos
	mov	ax,ss
	mov	ds,ax			;restore normal
	call	initbl
	mov	al,fcb+1
	cmp	al,' '+1
	jb	restrt
	call	prtstr
	db	cr,lf,'Reading All Files for ',0
	mov	bx,offset fcb+1
	mov	ch,8
ardnam:	mov	al,[bx]
	call	typech
	inc	bx
	dec	ch
	jnz	ardnam
	call	lodall
	call	prtstr
	db	cr,lf,'Read Complete',cr,lf,0
	jmp	short fstcmd
;
restrt:	call	initbl
fstcmd:	call	prtstr
	db	cr,lf,'Type H for Help, ? for Stats',cr,lf,0
;
nxcmd:	xor	al,al
	mov	wfiflg,al
	mov	quiflg,al		;not quiet, no output
	mov	segflg,al		;clear segment use
	mov	sp,offset stack
	call	gtcmd
l01cf:	mov	bx,offset cmdbuf+2	;first chars of command
	cmp	word ptr 1[bx],':S'
	jz	segonl			;just change segment
	mov	al,[bx]			;get the char
	mov	bx,offset fcttbl
	mov	ch,(offset fctend-offset fcttbl)/3	;tbl entries
funlp:	cmp	al,cs:[bx]		;test char match
	jz	fndfun
	inc	bx
	inc	bx
	inc	bx
	dec	ch
	jnz	funlp
	jmp	cmerr
;
fndfun:	inc	bx
	mov	dx,cs:[bx]		;address of function
	jmp	dx
;
segonl:	inc	bx	;pre-adj
	call	updseg
	jmp	short nxcmd
;
fcttbl	db	cr
	dw	offset nxcmd
	db	';'
	dw	offset cmcmnt
	db	'A'
	dw	offset cmatmt
	db	'B'
	dw	offset cmbld
	db	'C'
	dw	offset cmctl
	db	'D'
	dw	offset cmdump
	db	'E'
	dw	offset cmentr
	db	'F'
	dw	offset cmfind
	db	'G'
	dw	offset cmexit
	db	'H'
	dw	offset cmhelp
	db	'K'
	dw	offset cmkill
	db	'L'
	dw	offset cmlist
;	db	'O'
;	dw	offset cmofst
	db	'P'
	dw	offset cmprlg
	db	'Q'
	dw	offset cmqiet
	db	'R'
	dw	offset cmread
	db	'S'
	dw	offset cmsave
	db	'T'
	dw	offset cmtrim
	db	'U'
	dw	offset cmusec
	db	'X'
	dw	offset cmpurg
	db	'Z'
	dw	offset cmeof
	db	'?'
	dw	offset cmstts
fctend	db	0
;
cmerr:	xor	al,al
	mov	wfiflg,al
	mov	quiflg,al		;clear output and silent flags
	pop	bx			;addr called from
	push	bx			;in case stack empty 
	call	prword			;show where for debugging
	call	prtstr
	db	'? Cmd. Error',7,cr,lf,0
	jmp	nxcmd
;
delim:	cmp	al,' '
	jz	deliok
	cmp	al,','
	jz	deliok
	call	cmerr	;expected delimiter missing
deliok:	ret

; Exit resource here
cmexit:
	mov	ax,4c00h	; say no errors
	int	21h

;
;	help function
;
cmhelp:	
; Test to see if extended help is needed.
	mov	al,byte ptr cmdbuf+3
	cmp	al,cr		; nothing there?
	je	full_help
	cmp	al,'X'		; help extended key
	jne	full_help
	jmp	extnd_help	; show extended help
full_help:
	call	prtstr			;lots to put out here!
;line  1
	db	cr,lf,'		     HELP ON RES86 -- COMMAND SUMMARY'
;line  2
	db	cr,lf,';ADDR,@COMMENT	ENTER COMMENT AT ADDR	'
	db	' @={;|*|\|} \=NL, ;=APPND, *=REPL INST'
;line  3
	db	cr,lf,';		LIST COMMENTS TABLE	'
	db	';ADDR,		DELETE COMMENT'
;line  4
	db	cr,lf,"A (SEE L)	ATTEMPT TO FIND DB'",'S	'
	db	'B (SEE L)	BUILD SYMBOL TABLE'
;line  5
	db	cr,lf,'C		DUMP CONTROL TABLE	'
	db	'CNNNN		DUMP CTRL TABLE AT NNNN'
;line  6
	db	cr,lf,'CNNNN,X		 SET CTRL (X=BEHISW)	'
	db	'DNNNN		DUMP FROM NNNN ON'
;line  7
	db	cr,lf,'DAAAA,BBBB	DUMP OVER RANGE		'
	db	'D,BBBB		DUMP THRU BBBB'
;line  8
	db	cr,lf,'D		DUMP A PAGE MORE	'
	db	'D=NN		SET DUMP SIZE DEFAULT'
;line  9
	db	cr,lf,'DS		DUMP THE SYMBOL TABLE	'
	db	'DS.SYMBOL	DUMP STARTING AT SYMBOL'
;line 10
	db	cr,lf,'ENNNN,.SYM[,M] ENTER SYMBOL INTO TABLE	'
	db	'FNNNN,SSSS	FIND NNNN AFTER SSSS'
;line 11
	db	cr,lf,'F OR FNNNN	CONT FIND OR FIND NNNN	'
	db	'SEG PFX OK ON CMDS A,B,C,D,F,L,O,;'
;	db	'ISSSS,OOOO	INC ADDRS>=SSSS BY OOOO'
;line 12
	db	cr,lf,'K.SYMBOL	KILL SYMBOL FROM TABLE	'
	db	'L		LIST NEXT '
	db	(initlcnt/10)+'0',(initlcnt mod 10)+'0'
	db	' LINES'
;line 13
	db	cr,lf,'LSSSS,EEEE	LIST OVER RANGE		'
	db	'L,EEEE		LIST TO EEEE'
;line 14
	db	cr,lf,'LSSSS		LIST '
	db	(initlcnt/10)+'0',(initlcnt mod 10)+'0'
	db	' LINES FROM SSSS	'
	db	'L=NN[,OTHERS]	SET LIST DEFAULT'
;line 15
;	db	cr,lf,'O		PRINT CURRENT OFFSET	'
;	db	'ONNNN		SET NEW OFFSET'
;line 16
	db	cr,lf,'PSSSS,EEEE	GENERATE PROGRAM PROLOG	'
	db	'Q		QUIET PREFIX'
;line 17
	db	cr,lf,'RFILENAME.COM	READ FILE @ OFFSET     	'
	db	'RFILENAME.CTL	READ CONTROL TABLE'
;line 18
	db	cr,lf,'RFILENAME.SMB	READ SYMBOL TABLE	'
	db	'RFILENAME.DOC	READ COMMENTS TABLE'
;line 19
	db	cr,lf,'RFILENAME.ALL	READ CTL, SMB, DOC, COM	'
	db	'SFILENAME.ASM	SAVE ASM FILE'
;line 20
	db	cr,lf,'SFILENAME.CTL	SAVE CTL FILE		'
	db	'SFILENAME.SMB	SAVE SYM FILE'
;line 21
	db	cr,lf,'SFILENAME.DOC	SAVE DOC FILE		'
	db	'SFILENAME.ALL	CTL, SYM, DOC'
;line 22
	db	cr,lf,'UNNNN		SET COMMENT TABLE ADDR	'
	db	'X		RESTART RES86'
;line 23
	db	cr,lf,'Z		WRITE EOF TO ASM FILE	'
	db	'?		PRINT STATISTICS'
;line 24
	db	cr,lf,0			;finished!!
	jmp	nxcmd
extnd_help:
	call	prtstr

	db	cr,lf,'Extended help for Resource-86'
	db	cr,lf,'G	Exit back to MS-DOS'
	db	cr,lf,'Segments may be overrriden with the SEGMENT override'
	db	' key such as DCS:0 for display code at Data Segment,offset 0'
	db	cr,lf,0
	jmp	nxcmd
;
cmtrim:	mov	al,trmflg
	not	al
	mov	trmflg,al
	or	al,al
	jz	trmof
	call	prtstr
	db	'Trim On',cr,lf,0
	jmp	nxcmd
;
trmof:	call	prtstr
	db	'Trim Off',cr,lf,0
	jmp	nxcmd
;
;
;
cmpurg:	call	prtstr
	db	'Y/N purge all symbols & CTL?',0
	call	gtcmd
	mov	al,byte ptr cmdbuf+2
	cmp	al,'Y'	;59h
	jnz	l02c9
	call	erstbl	;empty the segment tables
	jmp	restrt
;
l02c9:	cmp	al,'N'	;4eh
	jnz	cmpurg	;bad answer
	jmp	nxcmd
;
;
;
cmprlg:	mov	bx,offset cmdbuf+3
	mov	al,[bx]
	cmp	al,cr
	jnz	l02df
	call	cmerr
;
l02df:	call	gtval
	call	delim
	inc	bx
	push	dx
	push	bx
	mov	wfiflg,1
	call	pstg
	db	9,'TITLE',9,27h,0
	mov	bx,offset fcb+1
	mov	al,[bx]
	cmp	al,' '
	jz	nofnam
	mov	ch,8
pfnlp:	mov	al,[bx]
	call	typech
	inc	bx
	dec	ch
	jnz	pfnlp
	jmp	short pnmdun
;
nofnam:	call	pstg
	db	'DISASSEMBLY',0
;
pnmdun:	call	pstg
	db	27h,cr,lf,9,'ORG',9,0
	pop	bx
	pop	dx
	mov	al,dh
	call	xo0
	mov	al,dl
	call	xo
	mov	al,'H'	;48h
	call	typech
	call	crlf
	push	dx
	call	gtval
	cmp	al,cr
	jz	l031d
	call	cmerr
;
l031d:	pop	cx
	mov	bx,offset symbas
prlglp:	inc	bx
	inc	bx
	inc	bx
	mov	al,[bx]
	or	al,al
	jnz	l032c			;not table end
	jmp	nxcmd
;
l032c:	dec	bx
	dec	bx
	dec	bx
	mov	ax,[bx]
	sub	ax,cx
	jb	l033d
	mov	ax,[bx]
	sub	ax,dx
	jb	l0394
l033d:	inc	bx
	push	bx
	push	cx
	inc	bx
	inc	bx
	mov	ch,[bx]
	push	bx
	inc	bx
	mov	al,[bx]
	dec	bx
	cmp	al,'A'	;41h
	jb	nodisp
l034b:	inc	bx
	mov	al,[bx]
	cmp	al,'+'	;2bh
	jz	nodisp
	cmp	al,'-'	;2dh
	jz	nodisp
	dec	ch
	jnz	l034b
	pop	bx
	mov	ch,[bx]
	mov	wfiflg,1
l0362:	inc	bx
	mov	al,[bx]
	call	typech
	dec	ch
	jnz	l0362
	call	pstg
	db	9,'EQU',9,'.',0
	pop	cx
	pop	bx
	mov	al,[bx]
	or	al,al
	jz	l0380
	call	xo0
l0380:	dec	bx
	mov	al,[bx]
	call	xo
	mov	al,'H'	;48h
	call	typech
	call	crlf
	mov	wfiflg,0
l0394:	inc	bx
	inc	bx
	inc	bx
	mov	al,[bx]
	call	addfn
	inc	bx
	call	keychk
	jmp	prlglp
;
nodisp:	pop	bx
	pop	cx
	pop	bx
	jmp	l0394
;
sgreqs:	mov	bx,offset cmdbuf+4	;process segment request
	mov	ax,[bx]
	cmp	ax,':S'			; is xs: in place?
	jz	updseg			;yes, find which and set
	ret				;else do nothing
updseg:	dec	bx
	mov	al,[bx]	;first seg char
	sub	ah,ah			;start at 0
	cmp	al,'C'
	jz	segmch
	inc	ah
	cmp	al,'D'
	jz	segmch
	inc	ah
	cmp	al,'E'
	jz	segmch
	inc	ah
	cmp	al,'S'
	jz	segmch
	ret				;ignore any others
;
segmch:	mov	segsho,al		;for cmd. prompt display
	mov	segflg,al		;seg req given
	mov	al,ah			;count value
	sub	ah,ah
	mov	bx,ax			;in a base reg
	mov	cl,cs:byte ptr segmtb[bx]	;get bit patt.
	mov	opdtyp,cl		;init symb select
	mov	segmsk,cl		;for testing symbols
	mov	bl,12			;size of segment record
	mul	bl			;index segment records
	mov	bx,offset cofset 	;segment para word base
	add	bx,ax			;index to right seg.
	mov	ofsptr,bx		;save pntr for future use
	mov	ax,[bx]			;get this para value
	mov	curpar,ax		;to active para holder
	mov	ax,-8[bx]		;get segment length
	mov	cl,4
	shl	ax,cl			;convt to bytes
	mov	segsiz,ax		;for ctl tbl limits
	mov	dx,offset cmdbuf+3 	;dest
	mov	bx,offset cmdbuf+6 	;srce
	call	l03b2			;squeeze out segment chars
	ret
;
segmtb	db	0ch,04h,08h,00h
;
;
;
cmqiet:	mov	al,1
	mov	quiflg,al		;no screen output for now
	mov	dx,offset cmdbuf+2
	mov	bx,offset cmdbuf+3
	call	l03b2
	jmp	l01cf
;
l03b2:	mov	al,[bx]	;move cmd line
	xchg	bx,dx
	mov	[bx],al	;down a notch
	xchg	bx,dx
	inc	bx
	inc	dx
	cmp	al,cr
	jnz	l03b2
	ret
;
;
;
cmdump:	call	sgreqs
	mov	dx,dmpstt
	mov	bx,dmpcnt
	add	bx,dx
	mov	dmpend,bx
	mov	bx,offset cmdbuf+3
	mov	al,[bx]			;2nd cmd char
	cmp	al,cr
	jz	dmphdr			;continue last dump
	cmp	al,'S'	;53h
	jnz	l0411
	mov	al,1[bx]		;next char
	cmp	al,':'			;segment req coming? 
	jz	l0411			;looks like it
	jmp	dusymt
;
l0411:	cmp	al,'='	;3dh
	jnz	l0418
	jmp	sducnt
;
l0418:	cmp	al,','	;2ch
	jz	dump1
dump0:	call	gtval
	push	bx
	mov	bx,dmpcnt
	add	bx,dx
	mov	dmpend,bx
	pop	bx
dump1:	cmp	al,cr
	jz	dump3
	call	delim
	inc	bx
	push	dx
	call	gtval
	xchg	bx,dx
	mov	dmpend,bx
	pop	dx
dump3:	mov	bx,curofs
	push	bx
	add	bx,dx
	mov	dmpstt,bx
	mov	bx,dmpend
	pop	dx
	add	bx,dx
	mov	dmpend,bx
	cmp	al,cr
	jz	dmphdr
	call	cmerr
;
dmphdr:	call	prtstr	;give header 
	db	'Addr  +0   +2    +4   +6     +8   +A    +C   +E'
	db	'     ASCII',cr,lf,0
cntdmp:	mov	bx,dmpstt
	mov	es,curpar
dump4:	call	keychk
	push	bx
	sub	bx,curofs		;remove offset for addr print
	call	prword
	pop	bx
	push	bx
	call	prspc
dmpln:	mov	es,curpar
	mov	al,es:[bx]
	call	xo
	inc	bx
	mov	al,bl
	and	al,1
	jnz	wdspc1
	call	prspc
wdspc1:	mov	al,bl
	and	al,3
	jnz	wdspc2
	call	prspc
wdspc2:	mov	al,bl
	and	al,7
	jnz	wdspc3
	call	prspc
wdspc3:	mov	al,bl
	and	al,0fh
	jnz	dmpln
	call	pstar
	pop	bx
dmpasc:	mov	es,curpar
	mov	al,es:[bx]
	cmp	al,' '	;20h
	jb	period
	cmp	al,7fh
	jb	chrctr
period:	mov	al,'.'	;2eh
chrctr:	call	typech
	inc	bx
	mov	al,bl
	and	al,0fh
	jz	lcmplt
	and	al,7
	jnz	wdspc4
	call	prspc
wdspc4:	jmp	dmpasc
;
lcmplt:	call	pstar
	call	crlf
	mov	dmpstt,bx
	mov	ax,dmpend
	sub	ax,bx
	jnb	dump4
	jmp	nxcmd
;
sducnt:	inc	bx
	call	gtval
	inc	bx
	dec	dx
	xchg	bx,dx
	mov	dmpcnt,bx
	xchg	bx,dx
l04e8:	cmp	al,cr
	jnz	l04ef
	jmp	nxcmd
;
l04ef:	call	delim
	jmp	dump0
;
dusymt:	call	iecnt			;init items per line
	mov	bx,offset cmdbuf+4
	mov	al,[bx]
	cmp	al,'.'	;2eh
	jnz	frmbgn			;no start given
	call	lngth
	call	locsym
	jnb	frmsym
	mov	bx,insloc		;best approx
	jmp	frmsym
;
frmbgn:	mov	bx,offset symbas
frmsym:	call	prtstr
	db	'KEY: @-C=SS, D-G=DS, H-K=ES, L-O=CS, '
	db	'@DHL=UNDF, AEIM=BYTE, BFJN=WORD, CGKO=DWRD',cr,lf,0
agnsym:	mov	dx,[bx]			;symbol value
	inc	bx
	inc	bx
	inc	bx
	mov	al,[bx]			;string size
	or	al,al
	jz	spitcr			;end of table reached
l051a:	xchg	bx,dx
	call	prword			;output value
	xchg	bx,dx
	dec	bx
	mov	al,[bx]			;oprnd type byte
	inc	bx
	or	al,'@'			;make printable
	call	typech
	mov	al,' '
	call	typech
	mov	ch,[bx]
	mov	al,symmax+1
	sub	al,ch
	mov	cl,al			;pad spaces needed
	inc	bx
spit:	mov	al,[bx]
	call	typech
	inc	bx
	dec	ch
	jnz	spit
	mov	ch,cl
spit1:	call	prspc
	dec	ch
	jnz	spit1
	call	spcrlf
	call	keychk
	jmp	agnsym
;
spitcr:	call	crlf
	jmp	nxcmd
;
spcrlf:	dec	ecnt
	jz	spcry
	ret
;
spcry:	call	crlf
;
iecnt:	mov	ecnt,4
	ret
;
prntos:;	call	prtstr
;	db	'Offset = ',0
;	mov	bx,curofs
;	call	prword
	call	crlf
	jmp	nxcmd
;
;cmofst:	call	sgreqs		;any segment data?
;	mov	bx,offset cmdbuf+3
;	mov	al,[bx]
;	cmp	al,cr
;	jz	prntos			;just show curr value
;	call	gtval			;get new from user
;	cmp	al,cr
;	jz	l0557			;that must be all
;	call	cmerr
;
;l0557:	mov	curofs,dx		;active value in curofs
;	mov	bx,ofsptr		;where seg rcrd keeps it
;	mov	[bx],dx			;active segment update
;	jmp	nxcmd
;
gfnam:	mov	al,wrtflg
	or	al,al
	jz	l056a
	jmp	rrqerr
;
l056a:	mov	byte ptr fcb,al
	mov	byte ptr fcb+12,al
	mov	bx,offset cmdbuf+3
	mov	al,byte ptr cmdbuf+4
	cmp	al,' '			;20h
	jnz	l057d
	call	cmerr
;
l057d:	cmp	al,':'			;3ah
	jnz	nodriv
	mov	al,byte ptr cmdbuf+3
	sub	al,'@'			;40h
	mov	byte ptr fcb,al
	inc	bx
	inc	bx
nodriv:	mov	dx,offset fcb+1
	mov	ch,8
	call	mvnfld
	mov	ch,3
	call	mvnfld
	ret
;
mvnfld:	mov	al,[bx]
	cmp	al,cr
	jz	padfld
	inc	bx
	cmp	al,'.'			;2eh
	jz	padfld
	xchg	bx,dx
	mov	[bx],al
	xchg	bx,dx
	inc	dx
	dec	ch
	jnz	mvnfld
eatfld:	mov	al,[bx]
	cmp	al,cr
	jnz	l05b6
	ret
;
l05b6:	inc	bx
	cmp	al,'.'			;2eh
	jnz	eatfld
	ret
;
padfld:	mov	al,' '			;20h
	xchg	bx,dx
	mov	[bx],al
	xchg	bx,dx
	inc	dx
	dec	ch
	jnz	padfld
	ret
;
;
;
cmatmt:	mov	bx,0001h
	jmp	short list1
;
cmbld:	mov	bx,0100h
	jmp	short list1
;
;
cmlist:	mov	bx,0000h
list1:	mov	word ptr ascbld,bx	;set two flags
	xor	al,al
	mov	wfiflg,al
	mov	al,byte ptr liscnt
	mov	byte ptr liscnt+1,al
	mov	cntenb,al		;assume line count range
	call	sgreqs			;check for segment spec.
	mov	bx,offset cmdbuf+3
	mov	al,[bx]
	cmp	al,cr
	jz	tenl			;do default amount
	cmp	al,','	;2ch
	jz	list3
	cmp	al,' '	;20h
	jz	list3			;first param null
	cmp	al,'='	;3dh
	jnz	list2
	jmp	slicnt			;change list amount
;
list2:	call	gtval			;get first parm
	mov	pcntr,dx		;where to start
	cmp	al,cr
	jz	tenl			;only start given
	call	delim
list3:	inc	bx			;pass delimiter
	call	gtval			;get 2nd parm
	mov	lastwd,dx		;addr to stop at
	mov	cntenb,0		;not specific line count
;
tenl:	call	keychk
	test	cntenb,0ffh
	jz	contl
	mov	al,byte ptr liscnt+1
	dec	al
	jns	flagck
	jmp	nxcmd
;
contl:	mov	es,curpar		;set to wanted segment
	mov	ax,pcntr
	sub	ax,lastwd
	jb	flagck			;not at end
	jmp	nxcmd
;
flagck:	test	ascbld,0ffh
	jz	morel			;not in 'A' mode
builda:	mov	bx,pcntr		;logical pointer
	add	bx,curofs
	mov	ch,8			;count to believe string
loop8:	mov	es,curpar
	mov	al,es:[bx]
	call	ifasci			;test for db prospects
	jb	morel			;doesnt look like it
	inc	bx
	dec	ch
	jnz	loop8			;if need more for faith
follow:	mov	es,curpar
	mov	al,es:[bx]
	inc	bx
	call	ifasci			;test how many more
	jnb	follow
	dec	bx			;to last ascii byte +1
	sub	bx,curofs		;get logical addr
	push	bx			;save for a bit
	mov	dx,pcntr		;start addr of string
	mov	al,'B'
	call	enterc			;make byte entry in ctl tbl
	pop	dx			;recover end addr
	mov	al,'I'			;back to 'I' at end
	call	enterc
morel:	mov	bx,doctbl
	or	bx,bx
	jz	ncmt			;nothing in comment table
	mov	bx,pcntr
	xchg	bx,dx
	call	comchk			;test for poss. comment
	jb	ncmt			;if none
	inc	bx
	inc	bx			;skip addr field
	mov	ch,[bx]			;byte count of comment
	mov	al,1[bx]		;first comment character
	cmp	al,';'			;append it?
	jnz	morel1
	mov	xcptr,bx		;save for append comment
	jmp	ncmt			; dont need it now
;
;this routine prints comment like this on separate line(s)
;
nwln:	stc				;semic to start
nwln0:	mov	wfiflg,1
	jnb	ncsemi
	call	semic			;start with semicolon
ncsemi:	or	ch,ch
	jnz	cntcmt			;if non zero count
	ret
;
cntcmt:	inc	bx			;update pntr
	mov	al,[bx]
	cmp	al,'\'			;'\' for multi-line comment
	jnz	ntbksl
	call	crlf			;break comment here
	dec	ch
	jmp	nwln0
;
ntbksl:	call	typech
	dec	ch
	jnz	cntcmt
	ret
;
morel1:	cmp	al,'*'			;substitute comment?
	jnz	morel2
	mov	rplptr,bx		;comment replaces instr
	jmp	ncmt			;but not right now
;
morel2:	call	nwln			;put out the comment
	call	crlf
;
ncmt:	mov	dx,pcntr
	call	ctlook			;find ctrl entry for this addr
	pushf
	dec	bx			;back to prev mode for default
	popf
	jb	cml15			;not matched addr, use prev mode
	add	bx,4			;use matched addr mode
cml15:	mov	al,[bx]			;mode char
	cmp	al,'I'			;49h
	jz	ictl			;do instruction list
	cmp	al,'E'			;45h
	jnz	l06fd
	jmp	cmeof			;show end & stop
;
l06fd:	push	ax
	inc	bx			;to next ctl rec base
	mov	dx,1[bx]		;addr value
	push	dx
	mov	bx,pcntr
	xchg	bx,dx
	call	hsym			;check for any label
	pop	bx
	mov	nxtctl,bx		;save addr to recheck ctrl
	xchg	bx,dx
	mov	wfiflg,0
	pop	ax
	cmp	al,'S' 			;space (rs) mode?
	jnz	ckbmd
	jmp	dsmode
;
ckbmd:	cmp	al,'B'			;byte mode?
	jnz	ckhmd
	jmp	bmode
;
ckhmd:	cmp	al,'H'			;force hex bytes?
	jnz	ckwmd
	jmp	hmode
;
ckwmd:	cmp	al,'W'			;word mode?
	jnz	badmd
	jmp	wmode
;
badmd:	call	typech
	call	prtstr
	db	': INVALID CTL ENTRY',cr,lf,0
	jmp	nxcmd
;
ictl:	call	dline			;disasm one instruction
	mov	wfiflg,0
	jmp	tenl
;
slicnt:	inc	bx
	call	gtval
	mov	al,dl			;one byte value
	or	al,al			;test if legal
	jnz	l0762
	call	cmerr
;
l0762:	mov	byte ptr liscnt,al	;save line count
	mov	byte ptr liscnt+1,al	;for curr use
	mov	al,[bx]			;what ended value
	inc	bx
l0776:	cmp	al,cr			;only define?
	jnz	l077d
	jmp	nxcmd
;
l077d:	call	delim
	jmp	list2
;
dsmode:	push	dx
	mov	bx,pcntr
	neg	bx
	add	bx,dx
	mov	wfiflg,1
	call	pstg
	db	'RS',9,0
	mov	al,bh
	call	xo0
	mov	al,bl
	call	xo
	mov	al,'H'			;48h
	call	typech
	call	dcrlf
	pop	bx
	mov	pcntr,bx
	jmp	tenl
;
wmode:	mov	al,1
	mov	wfiflg,al
	call	pstg
	db	'DW',9,0
	mov	bx,pcntr
	add	bx,curofs
	mov	es,curpar
	mov	dx,es:[bx]
	call	prntde
	call	crlf
	mov	bx,pcntr
	inc	bx
	inc	bx
	mov	pcntr,bx
	jmp	tenl
;
stpln:	call	dcrlf
	jmp	tenl
;
hmode:	xor	al,al
	jmp	short bmode1
;
bmode:	mov	al,0ffh
bmode1:	mov	adb,al			;set subtype flag
	mov	strcnt,0
	mov	wfiflg,1
	mov	bx,pcntr
	add	bx,curofs
	test	adb,0ffh
	mov	es,curpar
	mov	al,es:[bx]
	jz	nprtc
	cmp	al,' '			;20h
	jb	nprtc			;cant print ctrl codes
	cmp	al,7fh
	jnb	nprtc			;also unprintable
	jmp	conasc
;
nprtc:	call	pstg
	db	'DB',9,0
	xor	al,al
	mov	strcnt,al
morinv:	mov	es,curpar
	mov	al,es:[bx]
	cmp	al,lf
	jb	ltlf
	call	xo0
	mov	al,'H'			;48h
	call	typech
	mov	al,strcnt
	add	al,2
	mov	strcnt,al
	jmp	mvup
;
ltlf:	or	al,'0'			;30h
	call	typech
mvup:	inc	bx
	mov	dx,pcntr
	inc	dx
	mov	pcntr,dx
	cmp	dx,nxtctl
	jnz	trysym
	jmp	qtb
;
trysym:	mov	bx,pcntr
	xchg	bx,dx
	call	symluk
	jb	nstpln
	jmp	stpln
nstpln:	mov	al,strcnt
	add	al,2
	mov	strcnt,al
	cmp	al,25
	jb	l0864
	jmp	stpln
;
l0864:	mov	bx,pcntr
	add	bx,curofs
	test	adb,0ffh
	jz	nxinv
	mov	es,curpar
	mov	al,es:[bx]
	cmp	al,' '			;20h			
	jb	nxinv
	cmp	al,7fh
	jnb	nxinv
	jmp	stpln
;
nxinv:	mov	al,','			;2ch
	call	typech
	jmp	morinv
;
conasc:	call	pstg
	db	'DB',9,0
	mov	strcnt,0
	mov	al,''''			;27h
	call	typech
	add	strcnt,1
	mov	es,curpar
	mov	al,es:[bx]
morasc:	call	typech
	mov	es,curpar
	mov	al,es:[bx]
	cmp	al,''''			;27h
	jnz	l08ac
	call	typech
l08ac:	inc	bx
	mov	dx,pcntr
	inc	dx
	mov	pcntr,dx
	cmp	dx,nxtctl
	jz	fnlqt
yet:	push	bx
	mov	bx,pcntr
	xchg	bx,dx
	call	symluk
	pop	bx
	jnb	fnlqt
	mov	al,strcnt
	inc	al
	mov	strcnt,al
	cmp	al,35			;23h
	jnb	lastqt
	cmp	al,25
	jb	still
	dec	bx
	mov	es,curpar
	mov	al,es:[bx]
	inc	bx
	cmp	al,' '			;20h
	jz	fnlqt
still:	mov	es,curpar
	mov	al,es:[bx]
	cmp	al,' '			;20h
	jb	lastqt
	cmp	al,7fh
	jb	morasc
lastqt:	mov	al,''''			;27h
	call	typech
	jmp	stpln
;
fnlqt:	mov	al,''''			;27h
	call	typech
qtb:	call	dcrlf
	jmp	tenl
;
;
;
cmstts:	call	prtstr
	db	'SYMTBL='
	db	0
	mov	bx,offset symbas
	call	prword
	mov	bx,symtp
	call	prword
	call	crlf
	call	prtstr
	db	'PC    =',0
	mov	bx,pcntr
	call	prword
	mov	bx,hiload
	call	prword
	call	crlf
	call	prtstr
	db	'PARA  =',0
	mov	bx,curpar
	call	prword
	call	crlf
	mov	bx,doctbl
	or	bx,bx
	jz	nodoct
	call	prtstr
	db	'COMNTS='
	db	0
	mov	bx,doctbl
	call	prword
	mov	bx,docend
	call	prword
	call	crlf
nodoct:	call	prtstr
	db	'CTLTBL='
	db	0
	mov	bx,offset ctlbas
	call	prword
l0984:	mov	ax,1[bx]
	and	al,ah
	add	bx,4
	inc	al
	jnz	l0984
	sub	bx,4
	call	prword
	call	crlf
;
	call	prtstr
	db	'SEG. LGTH BASE SMIN SMAX PARA',cr,lf,0
	mov	bx,offset cstbl
sgplp:	mov	al,[bx]
	or	al,al
	jz	sgpen			;found end flag
	cmp	al,' '			;used entry?
	jnz	usdseg
	add	bx,12
	jmp	short sgplp
usdseg:	mov	ch,2
	call	pstrg			;segment label & order nr
	call	prtstr
	db	':  ',0
	call	prwval
	call	prwval
	call	prwval
	call	prwval
	call	prwval
	call	crlf
	jmp	short sgplp
;
sgpen:	jmp	nxcmd
;
prwval:	mov	dx,[bx]
	xchg	bx,dx
	call	prword
	xchg	bx,dx
	inc	bx
	inc	bx
	ret
;
;
;
cmfind:	call	sgreqs
	mov	bx,offset cmdbuf+3
	mov	al,[bx]
	cmp	al,cr
	jz	prevf
	call	gtval
	xchg	bx,dx
	mov	fndadd,bx
	mov	bx,curofs
	mov	fndpc,bx
	xchg	bx,dx
	cmp	al,cr
	jz	prevf
	call	delim
l09c6:	inc	bx
	call	gtval
	cmp	al,cr
	jz	l09d1
	call	cmerr
;
l09d1:	mov	es,curpar
	mov	bx,curofs
	add	bx,dx
	mov	fndpc,bx
prevf:	mov	bx,fndadd
	xchg	bx,dx
nyet:	call	keychk
;add topchk here
	mov	bx,fndpc
	mov	es,curpar
	mov	al,es:[bx]
	inc	bx
	mov	fndpc,bx
	cmp	al,dl
	jnz	nyet
	mov	es,curpar
	mov	al,es:[bx]
	cmp	al,dh
	jnz	nyet
	push	bx
	push	dx
	sub	bx,curofs
	dec	bx
	call	prword
	pop	dx
	pop	bx
	call	prspc
	jmp	nyet
;topchk can be put here
;
;
cmeof:	call	hsym
	mov	wfiflg,1
	call	pstg
	db	'END',cr,lf,0
	xor	al,al
	mov	wfiflg,al
	mov	al,wrtflg
	or	al,al
	jnz	l0a35
	jmp	nxcmd
;
l0a35:	mov	al,1ah
	call	wtfchr
	call	flushf
	xor	al,al
	mov	wrtflg,al
	call	prtstr
	db	'++ASM FILE CLOSED++',cr,lf,0
	jmp	nxcmd
;
;
;
cmread:
	call	gfnam
	mov	al,wrtflg
	or	al,al
	jz	rdaprv			; ok to read, now write current
	jmp	rrqerr
;
rdaprv:	mov	bx,offset fcb+9
	mov	dx,offset litall
	mov	cl,3
	call	cmpstr
	jz	wntall			;not rqst to load all
	jmp	ntlall
wntall:	call	lodall			;callable due to cmd line use
	jmp	cmstts
;
lodall:	mov	bx,offset litcmd
	call	chgtyp
	call	prtstr
	db	cr,lf,'Reading .COM file..',cr,lf,0
	call	lodcmd
;
	mov	bx,offset litdoc
	call	chgtyp
	call	prtstr
	db	cr,lf,'Reading .DOC file..',cr,lf,0
	call	loddoc
;
	mov	bx,offset litctl
	call	chgtyp
	call	prtstr
	db	cr,lf,'Reading .CTL file..',cr,lf,0
	call	lodctl
;
	mov	bx,offset litsym
	call	chgtyp
	call	prtstr
	db	cr,lf,'Reading .SMB file..',cr,lf,0
	call	lodsym
	ret
;
chgtyp:	mov	dx,offset fcb+9
	mov	ch,3
	mov	fcb+12,0		;clear extent
	jmp	mvnfld
;
ntlall:	mov	bx,offset fcb+9
	mov	dx,offset litsym
	mov	cl,3
	call	cmpstr
	jnz	l0a8a
	mov	bx,offset symbas
	call	ldasfl
	jnc	symffd
	jmp	nxcmd
symffd:	call	ldsym2
	jmp	cmstts
;
l0a8a:	mov	bx,offset fcb+9
	mov	dx,offset litcmd
	mov	cl,3
	call	cmpstr
	jz	wntcmd
	jmp	l0adc
wntcmd:	call	lodcmd
	jmp	nxcmd
;
lodcmd:	call	fopen			; locate the prog image
	jnc	cmdlds			; found one to load
	ret
;
cmdlds:	call	erstbl			; start clean
	mov	ax,mcbbas
	or	ax,ax
	jz	modofs
;	push	es
;	mov	es,ax
;	mov	ah,49h			; release memory
;	call	bdos
;	pop	es
modofs:	
	xor	dx,dx
	mov	ax,word ptr fcb+10h     ; the small part of file (com file)
	mov	cx,16
	div	cx			; convert to paras
	adc	ax,0			; any carry
	mov	mcbsiz,ax		;how much we want
	mov	bx,ax
;	mov	ah,48h			;memory request
;	call	bdos
;	jnc	mrqok			;if granted
;	call	prtstr
;	db	'Memory Allocation Error',7,0dh,0ah,0
;	jmp	nxcmd

	mov	bx,offset symbas
	sub	bx,100h			; size of program
	mov	cl,4
	shr	bx,cl
	add	bx,640			; size of pgm in paras + 10K sym area
	mov	ax,cs
	add	ax,bx			; convert to segment
mrqok: 
	mov	mcbbas,ax		; save segment
	mov	curpar,ax

; Now have to build a FAKE segment table for the com file

	mov	bx,offset fake_comtbl
	mov	dx,offset cstbl
	mov	ax,mcbsiz
	mov	[bx+1],ax
	mov	[bx+10],ax
	mov	[bx+19],ax
	mov	[bx+28],ax
	mov	ax,mcbbas
	mov	[bx+3],ax
	mov	[bx+12],ax
	mov	[bx+21],ax
	mov	[bx+30],ax
cmhlp:
	mov	al,[bx]			; segment type byte
	inc	bx
	add	al,al
	jz	set_dmablk
	inc	nrsegs
	push	bx			; save hdr ptr around move
	sub	ah,ah
	mov	bx,offset segnam-2	; no type 0
	add	bx,ax
	mov	cx,bx
	xchg	bx,dx
	mov	[bx],cx			; seg name in place
	xchg	bx,dx
	inc	dx
	inc	dx
	pop	bx			; hdr ptr back
	mov	ch,4			; words to move
cmhmlp:
	mov	ax,[bx]			; move seg data
	xchg	bx,dx
	mov	[bx],ax			; into table area
	xchg	bx,dx
	add	bx,2
	add	dx,2
	dec	ch
	jnz	cmhmlp
	add	dx,2			; skip over para in table
	jmp	short cmhlp

set_dmablk:
	sub	dx,dx			;cheap 0
	mov	cofset,dx
comrd_lp:
	mov	ax,mcbbas
	push	ds
	mov	ds,ax			; segment will be here
	mov	ah,26
	call	bdos			;dma offset = 0
	pop	ds
	mov	dx,offset fcb
	mov	ah,14h			;read data to mem
	call	bdos
	or	al,al
	jnz	l0ac4			;end or trbl
	mov	dx,cofset
	add	dx,128			; + 128 bytes
	mov	cofset,dx
	jmp	short comrd_lp
	
l0ac4:
	mov	word ptr cofset,0	; restore offset
	mov	bx,mcbsiz
	call	prword			;total file size in para
	call	crlf
	call	fclose
	mov	dx,offset tbuf
	mov	ah,1ah
	call	bdos			;restore dma offset
	mov	word ptr pcntr,0h	; set program counter
	ret
;
;
l0adc:	mov	bx,offset fcb+9
	mov	dx,offset litctl
	mov	cl,3
	call	cmpstr
	jnz	l0aec
	call	lodctl
	jmp	nxcmd
;
l0aec:	mov	bx,offset fcb+9
	mov	dx,offset litdoc
	mov	cl,3
	call	cmpstr
	jz	doclod
	call	cmerr
;
doclod:	call	l1041			;check for space assigned
	mov	bx,doctbl
	mov	sdflg,1			;flag no type byte
	call	ldasfl
	jnb	gotdoc			;if good read
	jmp	nxcmd
gotdoc:	call	lddoc2
	jmp	cmstts
;
lodsym:	mov	bx,offset symbas	;table start
	mov	sdflg,0			;flag for symb type
	call	ldasfl			;file data to memory
ldsym2:	mov	symtp,bx
	mov	byte ptr 3[bx],0 	;zero count = end flag
	ret
;
loddoc:	call	l1041
	mov	sdflg,1
	call	ldasfl
	jnb	lddoc2
	ret
;
lddoc2:	mov	docend,bx
	mov	word ptr [bx],0ffffh
	ret
;
;
ldasfl:	call	fopen
	jnc	skppre
	ret
skppre:	call	rdfchr
	cmp	al,1ah
	jnz	l0b6c
	push	bx
	call	fclose
	pop	bx
	ret
l0b6c:	cmp	al,' '
	jb	skppre			;ignore ctrl chars
	call	hexbin
	mov	[bx],dx			;value word
	inc	bx
	inc	bx
	test	sdflg,1
	jnz	drdsk1			;if no type byte
	call	rdfchr
	mov	[bx],al			;type byte
	inc	bx
	call	rdfchr			;eat delim space
drdsk1:	push	bx			;save locn for count
	inc	bx
	mov	ch,0
lpasld:	call	rdfchr
	cmp	al,9
	jz	ldassp
	cmp	al,cr			;found delim
	jz	ldassp
	mov	[bx],al
	inc	bx
	inc	ch			;char count
	jmp	lpasld
;
ldassp:	pop	si
	xchg	bx,si
	push	si
	mov	[bx],ch			;store byte count
	pop	bx
	jmp	skppre			;for another
;
hexbin:	mov	dx,0
l0ba3:	cmp	al,' '			;20h
	jnz	l0ba8
	ret
;
l0ba8:	cmp	al,1ah
	jnz	l0baf
	jmp	l0d20
;
l0baf:	cmp	al,'9'+1
	jb	l0bb5
	sub	al,7
l0bb5:	sub	al,'0'			;30h
	xchg	bx,dx
	add	bx,bx
	add	bx,bx
	add	bx,bx
	add	bx,bx
	add	al,bl
	mov	bl,al
	xchg	bx,dx
	call	rdfchr
	cmp	al,1ah
	jnz	l0ba3
	jmp	l0d20
;
erstbl:	mov	bx,offset cstbl
	mov	nrsegs,0
	mov	ch,8
etlp1:	mov	cl,5
	mov	ax,'  '
etlp2:	mov	[bx],ax
	xor	ax,ax
	inc	bx
	inc	bx
	dec	cl
	jnz	etlp2
	inc	bx
	inc	bx
	dec	ch
	jnz	etlp1
	ret
;
;
;
cmsave:	call	gfnam
	mov	al,wrtflg
	or	al,al
	jz	savok
	jmp	rrqerr
;
savok:	mov	bx,offset fcb+9
	mov	dx,offset litall
	mov	cl,3
	call	cmpstr
	jz	allsav
	jmp	ntsall
;
allsav:	mov	dx,docend
	mov	bx,doctbl
	cmp	bx,dx
	jz	nosdoc
	mov	bx,offset litdoc
	call	chgtyp
	call	prtstr
	db	cr,lf,'Saving .DOC file..',cr,lf,0
	call	savdoc
nosdoc:	mov	dx,symtp
	mov	bx,offset symbas
	cmp	bx,dx
	jz	nossym
	mov	bx,offset litsym
	call	chgtyp
	call	prtstr
	db	cr,lf,'Saving .SMB file..',cr,lf,0
	call	symsav
nossym:	mov	dx,ctltop
	mov	bx,offset ctlbas
	cmp	bx,dx
	jnz	havctl
	jmp	nxcmd
havctl:	mov	bx,offset litctl
	call	chgtyp
	call	prtstr
	db	cr,lf,'Saving .CTL file..',cr,lf,0
	jmp	savctl
;
ntsall:	mov	bx,offset fcb+9
	mov	dx,offset litsym
	mov	cl,3
	call	cmpstr
	jnz	ntssym
	call	symsav
	jmp	nxcmd
;
ntssym:	mov	bx,offset fcb+9
	mov	dx,offset litctl
	mov	cl,3
	call	cmpstr
	jnz	ntsctl
	jmp	svctl0
;
ntsctl:	mov	bx,offset fcb+9
	mov	dx,offset litdoc
	mov	cl,3
	call	cmpstr
	jnz	ntsdoc
	call	savdoc
	jmp	nxcmd
;
symsav:	mov	bx,offset symbas
	mov	sdflg,0			;symbol mode, not .doc
l0bf4:	call	creatf
l0bf7:	mov	dx,[bx]			;address value
	inc	bx
	test	sdflg,1
	jnz	sdskp1			;if .doc, no type byte
	inc	bx
	mov	ah,[bx]			;symbol type byte
sdskp1:	inc	bx
	mov	al,[bx]	;string length
	inc	bx
	mov	ch,al
	or	al,al
	jz	oufend	;end of table found
	push	ax			;protect type byte
	call	outadr
	mov	al,' '	;20h
	call	wtfchr
	pop	ax
	test	sdflg,1
	jnz	l0c0c			;if .doc mode
	mov	al,ah
	or	al,'@'			;make type printable
	call	wtfchr
	mov	al,' '
	call	wtfchr
l0c0c:	mov	al,[bx]
	call	wtfchr			;output string char
	inc	bx
	dec	ch
	jnz	l0c0c
	mov	al,cr
	call	wtfchr			;end of line
	mov	al,lf
	call	wtfchr
	jmp	l0bf7
;
oufend:	mov	al,1ah
	call	wtfchr			;end of file
	call	flushf
	ret
;
ntsdoc:	mov	bx,offset fcb+9
	mov	dx,offset lita86
	mov	cl,3
	call	cmpstr
	jz	sava86
	call	cmerr
;
outadr:	mov	al,dh
	call	hexl
	call	wtfchr
	mov	al,dh
	call	hexr
	call	wtfchr
	mov	al,dl
	call	hexl
	call	wtfchr
	mov	al,dl
	call	hexr
	jmp	wtfchr
;
sava86:	mov	al,1
	mov	wrtflg,al
	xor	al,al
	mov	wfiflg,al
	call	creatf
	call	prtstr
	db	'++WRITING .ASM ENABLED',cr,lf
	db	'USE Z COMMAND OR E CONTROL TO CLOSE FILE++',cr,lf,0
	jmp	nxcmd
;
savdoc:	call	l1041
	mov	bx,docend
	mov	sdflg,1
	inc	bx
	inc	bx
	inc	bx
	mov	byte ptr [bx],0
	mov	bx,doctbl
	jmp	l0bf4
;
rrqerr:	call	prtstr
	db	'++NO FILE ACCESSES PERMITTED '
	db	'UNTIL .ASM CLOSED'
	db	cr,lf,0
	jmp	nxcmd
;
l0d20:	call	prtstr
	db	'++UNEXPECTED EOF'
	db	cr,lf,0
	jmp	nxcmd
;
;
;
;	control table structure as of 12/25/84
;	4 byte entries, 1 byte segment char,
;	2 byte binary address, 1 byte mode char
;	table terminated by 0ffffh in address bytes
;
cmctl:	call	sgreqs
	mov	bx,offset cmdbuf+3
	mov	al,[bx]
	cmp	al,cr
	jnz	l0d45			;have more info
	jmp	clist0			;just list them all
;
l0d45:	call	gtval
	cmp	al,cr
	jnz	l0d4f			;more than one item
	jmp	l0e65			;partial list
;
l0d4f:	call	delim
l0d5a:	inc	bx
	mov	al,[bx]			;letter to use comes next
	call	entrc4			;make a manual entry
	jmp	nxcmd
;
enterc:	push	bx			;make entry from 'A' function
	push	dx			;pcntr to locate
	push	ax			;mode char in al
	call	ctlook			;search ctl table
	pushf
	dec	bx			;back to prev mode char
	popf				;flags restored
	jb	entrc2			;if table end or past right addr
	add	bx,4			;pnt to curr mode char
entrc2:	pop	ax			;char wanted
	pop	dx			;and pcntr value
	cmp	al,[bx]			;cmpar to current entry
	pop	bx			;stack in order
	jnz	entrc4			;is a needed entry
	ret			;nothing to do
;
entrc4:	mov	typndx,al	;save ctrl char
	call	ctlook		;find place for it
	jnb	l0d84		;matches an existing entry
	jmp	entrc5		;go make a new entry
;
l0d84:	mov	al,typndx	;recover the char
	call	cltrck		;test all legal values
	cmp	al,'K'
	jz	l0dba		;want kill
	jmp	l0e34		;modify existing entry
l0dba:	mov	ax,1[bx]	;addr field of rec
	and	al,ah
	inc	al
	jz	l0bf5		;if at table end
	mov	ch,4		;record size
l0dc6:	mov	al,4[bx]		;move from higher rec
	mov	[bx],al		;down to lower rec
	inc	bx
	dec	ch		;until record moved
	jnz	l0dc6
	jmp	l0dba		;repeat for rest of recs
;
cltrck:	cmp	al,'K'
	jz	cltrrt
ctlck2:	cmp	al,'E'
	jz	cltrrt
	cmp	al,'B'
	jz	cltrrt
	cmp	al,'H'
	jz	cltrrt
	cmp	al,'W'
	jz	cltrrt
	cmp	al,'I'
	jz	cltrrt
	cmp	al,'S'
	jz	cltrrt
	call	cmerr
;
cltrrt:	ret
;
l0bf5:	sub	bx,4		;base of last valid entry
	jmp	nodoct
;
entrc5:	mov	al,typndx	; want to add a record
	call	ctlck2		;test for legal to store
	push	dx		; addr val to store
	push	bx		; where to put new record
	mov	bx,offset ctlbas ;first field table end
entrc7:	mov	ax,1[bx]	; addr value this entry
	add	bx,4		; to start next rcrd
	and	al,ah		;combine bytes
	inc	al		;test for end flag
	jnz	entrc7		;not at end, srch more
	mov	dx,bx		;copy it
	add	dx,4		;space for new record
	pop	cx		;table insert location
entrc8:	dec	bx
	dec	dx
	mov	al,[bx]		;old entry byte
	xchg	bx,dx
	mov	[bx],al		; to new place higher
	xchg	bx,dx
	cmp	dx,cx		;at insert location yet?
	jnz	entrc8		; till there
	mov	bx,cx		;restore tbl pntr
	pop	dx		; pcntr value to place
	mov	ch,segsho	;segment char
	mov	[bx],ch
	mov	1[bx],dx	;store address value
	mov	al,typndx
	mov	3[bx],al	;store mode letter
	add	bx,4
	ret
;
l0e34:	mov	ah,segsho	;segment char
	mov	[bx],ah		;groups entry
	mov	3[bx],al	;modify existing entry
	ret
;
ctlook:	mov	bx,offset ctlbas ;table start
	mov	ch,segsho
ctlk2:	mov	ax,1[bx]	;addr value
	and	al,ah		;addr hi byte
	inc	al		;test for ffff
	stc			;to show end of tbl
	jnz	l0e4s		;wasnt the end flag
	ret
;
l0e4s:	cmp	ch,[bx]
	jz	l0e48		; in right segment
l0e5c:	jnb	ctlk4		;still too low in tbl
	ret			;too far, stop
;
l0e48:	cmp	dx,1[bx]
	jnz	l0e5c
	ret			;found exact match
;
ctlk4:	add	bx,4		;step an entry worth
	jmp	short ctlk2		;try another entry
;
;
l0e65:	call	iecnt
	call	ctlook		;find starting entry
	jmp	clist
;
clist0:	call	iecnt
	mov	bx,offset ctlbas ;start with first
clist:	call	keychk		;test for user break
	mov	dx,1[bx] ;addr from table entry
	add	bx,3
	mov	al,dh
	and	al,dl
	inc	al
	jnz	clist2		;not at table end
	call	crlf
	jmp	nodoct
;
clist2:	mov	al,-3[bx]
	cmp	al,segsho
	jnz	skclis		;ignore this one
	push	dx
	push	bx
	call	symluk		;symbol at this address?
	jb	l0e99		;no
	call	iecnt		;bump line count
	call	crlf		;and fresh start
l0e87:	mov	al,[bx]		;ctl mode char
	call	typech		;put out symb char
	inc	bx
	dec	ch		;till done
	jnz	l0e87
	mov	al,':'		;delimit it
	call	typech
	call	crlf
l0e99:	pop	bx
	pop	dx
	call	prspc
	call	prspc
	xchg	bx,dx
	call	prword		;output ctl tbl value
	mov	al,'='	;2ch
	call	typech		;delimiter
	mov	al,' '
	call	typech		;and space
	xchg	bx,dx
	mov	al,[bx]
	call	typech		;char from table
	call	prspc
	call	prspc
	call	spcrlf
skclis:	inc	bx
	jmp	clist
;
savctl:	call	svctl0
	jmp	nxcmd
;
svctl0:	call	creatf		;make a new file
	mov	bx,offset ctlbas ;table start
l0ebf:	mov	dx,1[bx]	;address value
	mov	al,dh
	and	al,dl
	inc	al
	jz	l0ee6		;if table end flag ffff
	mov	al,[bx]		;seg char
	call	wtfchr
	call	outadr
	mov	al,','	;2ch
	call	wtfchr
	mov	al,3[bx]
	call	wtfchr
	mov	al,cr
	call	wtfchr
	mov	al,lf
	call	wtfchr
	add	bx,4
	jmp	l0ebf
;
l0ee6:	mov	al,1ah
	call	wtfchr
	call	flushf
	jmp	nxcmd
;
lodctl:	call	fopen
	jnb	ctlfnd		;have one
	ret
ctlfnd:	mov	bx,offset ctlbas
l0ef7:	call	rdfchr
	cmp	al,1ah
	jz	l0f30		;if eof
	cmp	al,' '+1
	jb	l0ef7		;eat space and ctrl chars
	mov	[bx],al		;segment char
	call	rdfchr
	mov	dx,0		;clear addr accum
l0efd:	cmp	al,1ah
	jz	l0f30		;if eof
	cmp	al,','	;2ch
	jz	l0f23		;if delim
	cmp	al,'9'+1
	jb	l0f0b		;if can be dec digit
	sub	al,7		;alpha to hex
l0f0b:	sub	al,'0'	;30h	;to bin
	add	dx,dx
	add	dx,dx
	add	dx,dx
	add	dx,dx
	add	dl,al
	call	rdfchr		;whats next
	jmp	l0efd
;
l0f23:	mov	1[bx],dx
	call	rdfchr
	mov	3[bx],al
	add	bx,4
	jmp	l0ef7
;
l0f30:	mov	word ptr 1[bx],0ffffh
	add	bx,4
	call	fclose
	ret
;
;
;
;	comment table structure, variable lgth records
;	2 byte address, 1 byte string count, n byte string
;	table terminated by 0ffffh in address field
;	no table exists if doctbl = 0
;	if char 1 = ; comment appended to instruction
;	if char 1 = * comment replaces instruction
;	else comment on separate line before instruction
;
cmcmnt:	call	l1041
	call	sgreqs
	mov	bx,offset cmdbuf+3
	mov	al,byte ptr [bx]
	cmp	al,cr
	jnz	cmnt0
	jmp	l0fd4
;
cmnt0:	cmp	al,'0'
	jnz	cmnt1
	inc	bx
	mov	al,[bx]
	sub	al,'F'
	jz	cmnt2
	cmp	al,'N'-'F'
	jz	cmnt2
	call	cmerr
;
cmnt2:	mov	xcsw,al
	jmp	nxcmd
;
cmnt1:	call	gtval
	inc	bx
	cmp	al,cr
	jnz	l0f52
	jmp	l0fce
;
l0f52:	call	delim
l0f5d:	push	bx
	call	comchk
	jb	l0f71
	call	l100b
	pop	bx
	push	bx
	mov	al,[bx]
	cmp	al,cr
	jnz	l0f71
	jmp	nxcmd
;
l0f71:	mov	bx,docend
	mov	[bx],dx
	inc	bx
	inc	bx
	pop	dx
	mov	ch,0
	push	bx
l0f7d:	inc	bx
	xchg	bx,dx
	mov	al,[bx]
	xchg	bx,dx
	mov	[bx],al
	inc	dx
	inc	ch
	xchg	bx,dx
	mov	al,[bx]
	xchg	bx,dx
	cmp	al,cr
	jnz	l0f7d
	inc	bx
	mov	docend,bx
	mov	word ptr [bx],0ffffh
	pop	bx
	mov	[bx],ch
	jmp	nxcmd
;
comchk:	mov	bx,doctbl
l0fa6:	mov	al,[bx]
	inc	bx
	and	al,[bx]
	dec	bx
	inc	al
	stc
	jnz	l0fb2
	ret
;
l0fb2:	inc	bx
	mov	al,dh
	cmp	al,[bx]
	pushf
	dec	bx
	popf
	jnz	l0fc3
	mov	al,dl
	cmp	al,[bx]
	jnz	l0fc3
	ret
;
l0fc3:	inc	bx
	inc	bx
	mov	al,[bx]
	call	addfn
	inc	bx
	jmp	l0fa6
;
l0fce:	call	comchk
	jmp	l0fd8
;
l0fd4:	mov	bx,doctbl
l0fd8:	call	keychk
	mov	dl,[bx]
	inc	bx
	mov	dh,[bx]
	inc	bx
	mov	al,dh
	and	al,dl
	inc	al
	jnz	l0fec
	jmp	nxcmd
;
l0fec:	xchg	bx,dx
	call	prword
	xchg	bx,dx
	mov	al,';'	;3bh
	call	typech
	mov	ch,[bx]
l0ffa:	inc	bx
	mov	al,[bx]
	call	typech
	dec	ch
	jnz	l0ffa
	call	crlf
	inc	bx
	jmp	l0fd8
;
l100b:	mov	al,[bx]
	inc	bx
	and	al,[bx]
	inc	al
	jnz	l1015
	ret
;
l1015:	dec	bx
	push	dx
	mov	dx,bx
	inc	bx
	inc	bx
	mov	al,[bx]
	call	addfn
	inc	bx
	mov	ch,0
l1023:	mov	al,[bx]
	xchg	bx,dx
	mov	[bx],al
	xchg	bx,dx
	inc	bx
	inc	dx
	mov	cl,al
	and	al,ch
	inc	al
	mov	ch,cl
	jnz	l1023
	xchg	bx,dx
	dec	bx
	dec	bx
	mov	docend,bx
	pop	dx
	ret
;
l1041:	mov	bx,doctbl
	mov	al,bh
	or	al,bl
	jz	l104c
	ret
;
l104c:	call	prtstr
	db	'++COMMAND IGNORED++',cr,lf
	db	'++ISSUE ','UNNNN',' TO TELL '
	db	'RESOURCE TO USE ADDRESS NNNN',cr,lf
	db	'AS THE START OF THE COMMENTS TABLE',cr,lf,0
	jmp	nxcmd
;
;
;
cmusec:	mov	bx,offset cmdbuf+3
	mov	al,[bx]
	cmp	al,cr
	jnz	l10ce
	call	cmerr
;
l10ce:	cmp	al,'.'	;2eh
	jnz	ustok
	call	cmerr
;
ustok:	call	gtval
	push	dx
	mov	bx,hiload
	mov	dx,curofs
	add	bx,dx
	inc	bh
	mov	dx,bx
	pop	bx
	cmp	bx,dx
	jb	l10ef
	call	uaset
	jmp	nxcmd
;
uaset:	mov	doctbl,bx
	mov	docend,bx
	mov	word ptr [bx],0ffffh
	jmp	nxcmd
;
l10ef:	call	prtstr
	db	'++NO!! <=',0
	mov	bx,offset symbas
	call	prword
	call	prtstr
	db	'!',cr,lf,0
	jmp	nxcmd
;
hsym:	push	dx
	push	bx
	mov	wfiflg,1
	mov	bx,pcntr
	xchg	bx,dx
	call	symluk
	jb	l1152		;no symbol/label here
	mov	cl,ch
	push	bx
l111c:	mov	al,[bx]
	cmp	al,'+'	;2bh
	jz	l1151
	cmp	al,'-'	;2dh
	jz	l1151
	inc	bx
	dec	cl
	jnz	l111c
	pop	bx
	call	pstrg
	mov	al,symtyp
	and	al,0fh
	cmp	al,0ch
	jnz	l1152 
	mov	al,':'	;3ah
	call	typech
	mov	al,trmflg
	or	al,al
	jnz	l1152
	call	tabc
	call	tabc
	call	semic
	mov	bx,pcntr
	call	prword
	call	crlf
	jmp	l1152
;
l1151:	pop	bx
l1152:	mov	wfiflg,0
	call	prspc
	call	prspc
	mov	bx,pcntr
	call	prword
	mov	wfiflg,1
	call	tabc
	pop	bx
	pop	dx
	ret
;

code	ends
	end

