;
; Copyright (C) 2000 Grzegorz Kowal
;

;;
;; EVERY DAY EQUATES AND MACROS
;;

		LOCALS

		LF		EQU	0Dh,0Ah
		EOM		EQU	0Dh,0Ah,'$'

		GLOBAL		Convert:PROC
		GLOBAL		ConvertH:PROC
		GLOBAL		CheckCPU:PROC
		GLOBAL		CPUID:PROC


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Term () -- terminates the program.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
Term		MACRO
		IFDEF	MousePresent
		  xor ax,ax
		  DosInt 33h
		ENDIF
		IFDEF	VESAPresent
		  mov ax,03h
		  DosInt 10h
		ENDIF
		mov	ax,4C00h
		int	21h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Kill (Error msg) -- terminates the program (error exit).
;;
;; Expects:	Error msg OFFSET
;;
;; Returns:	nothing
;;
Kill		MACRO	P1
		IFDEF	MousePresent
		  xor ax,ax
		  DosInt 33h
		ENDIF
		mov	ah,Exit_Error
		mov	edx,O P1
		Int_EOS
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetClock ()    
;; Returns timer ticks in EAX.
;;
;; Expects:	nothing
;;
;; Returns:	EAX	= timer ticks since last reset.
;;
;; Note:	Fq	= 1.19318 MHz
;;			18.2 t/s
;;			65536 t/h
;;
GetClock	MACRO
		push	es
		mov	ax,40h
		mov	es,ax
		mov	eax,es:[6Ch]
		pop	es
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; ClockSync ()    
;; Waits until the clock triggers.
;;
;; Expects:	nothing
;;
;; Returns:	EAX	= timer
;;
ClockSync	MACRO
LOCAL		loop1
		push	es
		mov	ax,40h
		mov	es,ax
		mov	eax,es:[6Ch]
loop1:
		cmp	eax,es:[6Ch]
		je	loop1
		mov	eax,es:[6Ch]
		pop	es
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; DosF (func #)    
;; Calls dos function via int 21h.
;;
;; Expects:	funtcion number (byte)
;;
;; Returns:	*
;;
DosF		MACRO	P1
		mov	ah,P1
		int	21h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; PutChar (char)
;; Displays a character with Ctrl-Break check.
;;
;; Expects:	char (byte)
;;
;; Returns:	nothing
;;
PutChar		MACRO	P1
		push	dx
		mov	ah,2h
		mov	dl,P1
		int	21h
		pop	dx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Print (offset)
;; Displays a string.
;;
;; Expects:	offset (ASCII$ string)
;;
;; Returns:	nothing
;;
Print		MACRO	P1
		push	edx
		mov	edx,O P1
		mov	ah,09h
		int	21h
		pop	edx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; ClearKB ()
;; Clear the keyboard buffer.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
;;ClearKB		MACRO
;;		push	ds
;;		xor	ax,ax
;;		mov	ds,ax
;;		mov	ax,001Eh
;;		cli
;;		mov	ds:[041Ah],ax
;;		mov	ds:[041Ch],ax
;;		sti
;;		pop	ds
;;		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetKey ()  ->  AH,AL
;; Reads a key without echo and Ctrl-Break check.
;;
;; Expects:	nothing
;;
;; Returns:	AH	= scan code
;;		AL	= ASCII char
;;
GetKey		MACRO
		xor	ah,ah
		DosInt	16h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; KeyPressed ()  ->  ZF,AH,AL
;; Checks if a character is ready.
;;
;; Expects:	nothing
;;
;; Returns:	ZF	= [0--ready, 1--not ready]
;;		AH	= scan code
;;		AL	= ASCII char
;;
KeyPressed	MACRO
		mov	ah,01h
		DosInt	16h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetChar ()  ->  AL
;; Reads and echos a character with Crtl-Break check.
;;
;; Expects:	nothing
;;
;; Returns:	AL	= char
;;
GetChar		MACRO
		mov	ah,1h
		int	21h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; Beep
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
Beep		MACRO
		push	dx
		mov	ah,02h
		mov	dl,7
		int	21h
		pop	dx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; CMOSr (address)
;;
;; Expects:	address
;;
;; Returns:	AL = data
;;
CMOSr		MACRO P1
		mov	al,P1
		out	70h,al
		jmp	$+2
		in	al,71h
		ENDM


Init_es_bx  macro Adrs
            mov ebx,[Code32_Addr]
            add ebx,O Adrs
            shr ebx,4
            mov Real_ES,ebx
            lea ebx,Adrs
            and ebx,0fh
            endm
