Date: Friday, 14 August 1987  04:43-MDT
From: Ya'akov_Miles%UBC.MAILNET at MIT-Multics.ARPA
To:   Info-IBMPC at C.ISI.EDU
Re:   Re INFO-IBMPC Digest 30 Efficient Block Transfers

Title   Loop
;Demonstrate Block Transfer technique, sometimes called Transfer Vectoring
COUNT           =12345                  ; Number of bytes to read
BLOCK_SIZE      =9                      ; Bytes per data transfer block
PORT            =241h                   ; Clock.  BCD seconds/100. (341h ?)
;
BLOCK_SIZE      =BLOCK_SIZE and 0FFFEh  ; Force even # of bytes/xfer block
;
Code    Segment                         ; Declare Segment before "Assume"
Assume  ds:Code,ss:Code,cs:Code,es:Code ; Segment order avoids "problems"...
        ORG     0100h                   ; Start address for .COM binary file
begin:  mov     di,offset DATA          ; ES:[DI] --> data area
        mov     cx,COUNT                ; Get total bytes to transfer
        mov     bx,BLOCK_SIZE           ; Get data transfer block size, BYTES
        mov     ax,cx                   ; Get lo order transfer byte count
        xor     dx,dx                   ;  ...zero hi order byte count
        div     bx                      ; AX = blocks, DX = remainder
        push    ax                      ;  ...save block count
        mov     cx,dx                   ; Get bytes in partial block
        mov     dx,PORT                 ;  ...load clock port
        jcxz    exact                   ; Exact number of blocks in transfer
;
fract:  in      al,dx                   ; Read BCD seconds/hundred.
        stosb                           ;  ...ES:[DI] --> (next) saved result
        loop    fract                   ;  ...until done
;
exact:  pop     cx                      ; Load number of blocks to transfer
        jcxz    done                    ;  ...less than one block in xfer
;
block:  Rept    BLOCK_SIZE/2            ; Unroll DO loop this amount, bytes
        in      al,dx                   ; Read BCD seconds/hundred
        xchg    ah,al                   ;  ...save temporary in register
        in      al,dx                   ; Read BCD seconds/hundred
        xchg    ah,al                   ;  ...swap bytes to IBM order. Yuk
        stosw                           ;  ...ES:[DI] --> (next) saved result
        Endm                            ;  ...end of unrolled DO loop
        loop    block                   ;  ...love FORTRAN
;
done:   ret                             ; Back to BASIC programming
data:                                   ;  ...data area after program
Code    ends
;
End     Begin
