==========
tech.notes/pc.code #29, from pmaupin, 3407 chars, Sat Jun  4 22:40:45 1988
----------
TITLE: Finding DOS's master environment pointer
This is a fragment of code that my SD.COM program uses to find
the environment.  This fragment is different than most ways of
finding the environment, in that it finds the MASTER environment block,
not the current process's parent's environment.

This is useful in some cases, and has the added advantage that
it does NOT behave differently when executing under CodeView,
so you do NOT have to hard-code your system's DOS environment address
into your program in order to debug it.


EnvPtr             EQU       2CH       ; Offset in PSP

CommandInterrupt   EQU       2EH       ; entry point into first Command.Com
                                       ; through interpreter

DosSegPtr          EQU       CommandInterrupt * 4 + 2


; FindEnvironment is passed:

;   DS should point to program PSP

; FindEnvironment returns:

;   ES points to master environment block, or program's copy if couldn't
;              find the master.

;   CX is length of block, or 0 if couldn't find the master.

; FindEnvironment destroys:

;   AX, SI


FindEnvironment    PROC  NEAR
                   xor   si,si                ; Point to segment 0
                   mov   es,si
                   mov   si, word ptr es:[DosSegPtr]
                   mov   ax,si
                   call  VerifyBlock          ; make sure we've found COMMAND
                   jnz   GotBlock             ; jump if not a good block --
                                              ; use process's environment

                   mov   ax,es:[EnvPtr+10h]   ; get COMMAND's environment ptr
                   or    ax,ax                ; jump if COMMAND has a
                   jnz   MaybeGoodBlock       ; subsidiary environment

                   mov   ax,si                ; If no subsidiary, just use
                   add   ax,cx                ; the allocation block
                   inc   ax                   ; immediately after COMMAND

MaybeGoodBlock:    call  VerifyBlock          ; verify that we have a good
                                              ; one, one way or another
GotBlock:
                   shl   cx,1                 ; multiply by 16 to get
                   shl   cx,1                 ; length in bytes
                   shl   cx,1
                   shl   cx,1
                   mov   es,ax
                   ret


; VerifyBlock tries to insure that we're pointing to a valid DOS
; allocation block.  If not, returns the current process's environment
; block.


VerifyBlock        PROC  NEAR
                   dec   ax                      ; get block header into ES
                   mov   es,ax
                   inc   ax

                   cmp   byte ptr es:[0],04Dh    ; make sure signature is valid
                   jnz   UseCurrent
                   cmp   word ptr es:[1],si      ; make sure owner is valid
                   jnz   UseCurrent
                   mov   cx, word ptr es:[3]     ; retrieve the length
                   ret

UseCurrent:        mov   ax,word ptr ds:[EnvPtr] ; get current process's env
                   xor   cx,cx                   ; zero length
                   ret
VerifyBlock        ENDP

FindEnvironment    ENDP

So far, this seems to work.  I would welcome any feedback on its
efficacy, but if the feedback is negative, please give the DOS version
and a detailed problem description.  Thanks,
Pat
