%ifndef LOADER
%assign RMCALL_VECT     RMCALL_VECT+1
%assign N_DSC           N_DSC-2         ; Loader allocates 2 descriptors
%assign N_INT           N_INT-1         ; Loader sets 1 interrupt gate

code32sel       dw      0
data32sel       dw      0
zerosel         dw      0
code16sel       dw      0
data16sel       dw      0
pspsel          dw      0
envsel          dw      0

IRQ0_vect       db      0
IRQ8_vect       db      0

v86r_edi:
v86r_di         dw      0
                dw      0
v86r_esi:
v86r_si         dw      0
                dw      0
v86r_ebp:
v86r_bp         dw      0
                dw      0
                dd      0
v86r_ebx:
v86r_bx:
v86r_bl         db      0
v86r_bh         db      0
                dw      0
v86r_edx:
v86r_dx:
v86r_dl         db      0
v86r_dh         db      0
                dw      0
v86r_ecx:
v86r_cx:
v86r_cl         db      0
v86r_ch         db      0
                dw      0
v86r_eax:
v86r_ax:
v86r_al         db      0
v86r_ah         db      0
                dw      0
v86r_flags      dw      0
v86r_es         dw      0
v86r_ds         dw      0
v86r_fs         dw      0
v86r_gs         dw      0
v86r_ip         dw      0
v86r_cs         dw      0
v86r_sp         dw      0
v86r_ss         dw      0

code16a         dd      0
code32a         dd      0
lomembase       dd      0
lomemtop        dd      0
himembase       dd      0
himemtop        dd      0
totalextmem     dd      0
hextbl          db      '0123456789ABCDEF'
systemtype      db      0
windows         db      0
returncode      db      0
                db      0,0,0           ; 3 bytes extra to align on dword

exit            dd      0
                dd      0               ; 1 word extra to align on dword
getmem          dd      0
                dd      0
getlomem        dd      0
                dd      0
gethimem        dd      0
                dd      0
lomemsize       dd      0
                dd      0
himemsize       dd      0
                dd      0
getdsc          dd      0
                dd      0
setdsc          dd      0
                dd      0
getvect         dd      0
                dd      0
setvect         dd      0
                dd      0
map_phys_addr   dd      0
                dd      0
dosshell        dd      0
                dd      0
dosprint        dd      0
                dd      0
putstr          dd      0
                dd      0

%else

SELSTART        equ     0
code32selOFF    equ     SELSTART
data32selOFF    equ     SELSTART+2
zeroselOFF      equ     SELSTART+4
code16selOFF    equ     SELSTART+6
data16selOFF    equ     SELSTART+8
pspselOFF       equ     SELSTART+10
envselOFF       equ     SELSTART+12

IRQSTART        equ     14
IRQ0_vectOFF    equ     IRQSTART
IRQ8_vectOFF    equ     IRQSTART+1

REGSTRUCOFF     equ     16

MISCSTART       equ     66
code16aOFF      equ     MISCSTART
code32aOFF      equ     MISCSTART+4
lomembaseOFF    equ     MISCSTART+8
lomemtopOFF     equ     MISCSTART+12
himembaseOFF    equ     MISCSTART+16
himemtopOFF     equ     MISCSTART+20
totalextmemOFF  equ     MISCSTART+24
hextblOFF       equ     MISCSTART+28
systemtypeOFF   equ     MISCSTART+44
windowsOFF      equ     MISCSTART+45
returncodeOFF   equ     MISCSTART+46
; 3 bytes extra to align on dword

FUNCSTART       equ     116
exitOFF         equ     FUNCSTART
getmemOFF       equ     FUNCSTART+8
getlomemOFF     equ     FUNCSTART+16
gethimemOFF     equ     FUNCSTART+24
lomemsizeOFF    equ     FUNCSTART+32
himemsizeOFF    equ     FUNCSTART+40
getdscOFF       equ     FUNCSTART+48
setdscOFF       equ     FUNCSTART+56
getvectOFF      equ     FUNCSTART+64
setvectOFF      equ     FUNCSTART+72
map_phys_addrOFF equ    FUNCSTART+80
dosshellOFF     equ     FUNCSTART+88
dosprintOFF     equ     FUNCSTART+96
putstrOFF       equ     FUNCSTART+104

%endif
