stdlib		segment	para public 'slcode'
		assume	cs:stdlib
		extrn	sl_malloc:far
;
;
astr		db	8 dup (?)
aindex		dw	0
;
; HTOA- Converts value in AL to a string of length two containing two
;	hexadecimal characters.  A pointer to this string gets returned
;	in the ES:DI registers.  Returns carry clear if no error.  Returns
;	carry set if there isn't enough room on the heap to allocate the
;	string.
;
		public	sl_htoa
sl_htoa		proc	far
		push	ax bx cx
		mov	cs:aindex, 0
		call	hextoa
;
; Move the digit string out onto the heap and return a pointer to it in
; es:si.
;
		mov	cx, cs:aindex
		mov	bx, cx			;Save for later.
		inc	cx
		call	sl_malloc               ;Allocate storage for string.
		jc	BadHTOA
CopyStrLp:	mov	al, cs:astr[bx]
		mov	es:[di][bx], al
		dec	bx
		jns	CopyStrLp
		clc
		pop	cx bx ax
		ret
;
BadHTOA:	stc
		pop	cx bx ax
		ret
sl_htoa		endp
;
;
; WTOA- Converts the binary value in AX to a string of four hexadecimal
;	characters.  Returns a pointer to the string in ES:DI.  Returns
;	carry clear if no error, carry set if an error occurred (not enough
;	space available in heap).
;
		public	sl_wtoa
sl_wtoa		proc	far
		push	ax bx cx
		mov	cs:aindex, 0
		xchg	al, ah
		call	hextoa
		xchg	al, ah
		call	hextoa
;
; Move the digit string out onto the heap and return a pointer to it in
; es:si.
;
		mov	cx, cs:aindex
		mov	bx, cx			;Save for later.
		inc	cx
		call	sl_malloc               ;Allocate storage for string.
		jc	BadWTOA
CopyStrLp2:	mov	al, cs:astr[bx]
		mov	es:[di][bx], al
		dec	bx
		jns	CopyStrLp2
		clc
		pop	cx bx ax
		ret
;
BadWTOA:	stc
		pop	cx bx ax
		ret
sl_wtoa		endp
;
;
;
hextoa		proc	near
		push	ax
		mov	ah, al
		shr	al, 1
		shr	al, 1
		shr	al, 1
		shr	al, 1
		add	al, 90h
		daa
		adc	al, 40h
		daa
		call	putit
		mov	al, ah
		and	al, 0fh
		add	al, 90h
		daa
		adc	al, 40h
		daa
		call	putit
		pop	ax
		ret
hextoa		endp
;
; PutIt- Writes the character in AL to the "astr" buffer.  Also zero
; terminates the string and increments aindex.  Note: no need to preserve
; DI here because no one else uses it.
;
PutIt		proc	near
		mov	di, cs:aindex
		mov	cs:astr[di], al
		mov	byte ptr cs:astr+1[di], 0
		inc     cs:aindex
		ret
PutIt		endp
;
stdlib		ends
		end
