;
stdlib		segment	para public 'slcode'
		assume	cs:stdlib
		extrn	sl_malloc:far
;
; Local variables for these routines:
;
astr		db	12 dup (?)
aindex		dw	0
;
;
; LTOA-	converts the value in DX:AX to a string.  Returns a pointer to this
;	string in ES:SI.  Carry=0 on return if no error, 1 if heap overflow.
;
		public	sl_ltoa
sl_ltoa		proc	far
		push	ax
		push	bx
		push	cx
		push	dx
		mov	cs:aindex, 0
		cmp	dx, 0
		jge	Doit
		push	ax
		mov	al, '-'
		call	Putit
		pop	ax
		neg	dx
		neg	ax
		sbb	dx, 0
;
DoIt:		call	puti2
;
; Move the digit string out onto the heap and return a pointer to it in
; es:si.
;
		mov	cx, cs:aindex
		mov	bx, cx			;Save for later.
		inc	cx
		call	sl_malloc               ;Allocate storage for string.
		jc	BadLTOA
CopyStrLp:	mov	al, cs:astr[bx]
		mov	es:[di][bx], al
		dec	bx
		jns	CopyStrLp
		clc
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		ret
;
BadLTOA:	clc
		pop	dx cx bx ax
		ret
sl_ltoa		endp
;
;
;
; ULTOA converts the unsigned dword value in DX:AX to a string and returns
;	a pointer to this string in ES:SI.  Carry=0 if no error, 1 if heap
;	overflow occurs.
;
		public	sl_ultoa
sl_ultoa	proc	far
		push	ax
		push	bx
		push	cx
		push	dx
		mov	cs:aindex, 0
		call	PutI2
;
; Move the digit string out onto the heap and return a pointer to it in
; es:si.
;
		mov	cx, cs:aindex
		mov	bx, cx			;Save for later.
		inc	cx
		call	sl_malloc               ;Allocate storage for string.
		jc	BadULTOA
CopyStrLp2:	mov	al, cs:astr[bx]
		mov	es:[di][bx], al
		dec	bx
		jns	CopyStrLp2
		clc
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		ret
;
BadULTOA:	stc
		pop	dx cx bx ax
		ret
sl_ultoa	endp
;
;
;
; PutI2- Recursive routine to actually print the value in AX as an integer.
;
Puti2		proc	near
		call	Div10
		cmp	ax, dx		;See if dx:ax=0
		jnz	NotDone
		or	ax, ax
		jz	Done
NotDone:	push	bx
		call	Puti2
		pop	bx
Done:		mov	al, bl
		or	al, '0'
		call	PutIt
		ret
PutI2		endp
;
; Div10- Divides DX:AX by 10 leaving the remainder in BL and the quotient
;	 in DX:AX.
;
Div10		proc	near
		mov	cx, 10
		mov	bx, ax
		xchg	ax, dx
		xor	dx, dx
		div	cx
		xchg	bx, ax
		div	cx
		xchg	dx, bx
		ret
Div10		endp
;
;
; PutIt- Writes the character in AL to the "astr" buffer.  Also zero
; terminates the string and increments aindex.  Note: no need to preserve
; SI here because no one else uses it.
;
PutIt		proc	near
		mov	di, cs:aindex
		mov	cs:astr[di], al
		mov	byte ptr cs:astr+1[di], 0
		inc     cs:aindex
		ret
PutIt		endp
stdlib		ends
		end
