stdlib		segment	para public 'slcode'
		assume	cs:stdlib
;
;
; strcspan-	Returns the number of characters at the beginning of a string
;		which are NOT from a specified set.
;
; inputs:
;
;	ES:SI-  Points at string to test.
;	DS:DI-	Points at set of characters (zero terminated string).
;
; outputs:
;
;	CX-	Number of characters not in the set which are the prefix of
;		the test string.
;
;
;
;
		public	sl_strcspan2
;
sl_strcspan2	proc	far
		pushf
		push	es
		push	ds
		push	ax
		push	bx
		push	dx
		push	si
		push	di
		cld
;
; Put the pointers into a couple of better locations.
;
		mov	ax, es
		mov	cx, ds
		mov	es, cx
                mov	ds, ax
;
		mov	bx, di			;Preserve ptr to char set.
		mov	cx, 0ffffh
		mov	al, 0
	repne	scasb				;Compute length of char set.
		neg	cx
		dec	cx
		dec	cx
		mov	dx, cx			;Save for use later.
;
; Okay, now we can see how many characters from the set match the prefix
; characters in the string.
;
StrLp:		lodsb				;Get next char in string.
		mov	cx, dx			;Get length of char set.
		mov	di, bx			;Get ptr to char set
	repne	scasb				;See if in set
		jnz	StrLp			;Repeat while not in set.
;
		pop	di
		pop	cx
		sub	si, cx
		xchg	cx, si
		dec	cx
		pop	dx
		pop	bx
		pop	ax
		popf
		pop	ds
		pop	es
		ret
sl_strcspan2	endp
;
;
;
;
stdlib		ends
		end
