	page 60,132
	title	DEMO12 - A STARTUP1/2 Demonstration Program MAIN Procedure
	name	DEMO12
comment 
	DEMO12							V1.00
==========================================================================
NAME
	DEMO12 - The Main Procedure for a STARTUP1 or STARTUP2 Demonstration
		 Program

DESCRIPTION
	This is the main procedure for a STARTUP1 or STARTUP2 demonstration
	program.  This procedure displays all the global variables
	initialized by STARTUP1 or STARTUP2, program name (STARTUP2 only),
	and all command line argruments.

CAUTIONS
	None

RETURNS
	Zero - always

PROGRAMMING NOTES
        Assembled with Microsoft MASM V6.11d

	Written to be assembled in any memory model

REGISTER USAGE
	All

MEMORY UTILIZATION
	Not calculated

EXTERNAL LIBRARIES
	Hex2Bin 		alib?
	Print			alib?
	Puts			alib?
	Stack_Check		alib?
	Startup_1/Startup_1S	alib?	; Depends if SIMPLE is defined
					; and non Tiny memory model.
					; Also may be Startup_2 or ...2_S
	Utoa			alib?

EXTERNAL PROCEDURES
	None

INTERRUPTS CALLED
	None

GLOBAL NAMES
	Main

AUTHOR
        Raymond Moon - 6 Oct 95
	Copyright (c) 1995, MoonWare
	ALL RIGHTS RESERVED

HISTORY
	Version	- Date		- Remarks
	1.00	-  6 Oct 95	- Orginal

==========================================================================
	 Comment End
	
;-----------------------------
; A	Make the small memory model the default

ifndef	memmod
memmod	equ	<small>
endif

;-----------------------------
; B	Include the processor, memory model, associate ES register with
;	DGROUP, and specify DOS segment order.

	include procesor.inc
%	.MODEL	memmod,FORTRAN
	assume	es:DGROUP
	.dosseg

;-----------------------------
; C	Include files

	include startup.inc
	include lib.inc

;=========================================================================
; D	MACROS
;=========================================================================
@LES	macro	reg, address
if @DataSize
	les     reg, address
else
	mov     reg, address
endif
endm

;=========================================================================
;	DATA
;=========================================================================
; E	Define required equates

CR	equ	13
LF	equ	10
NULL	equ	 0
If @DataSize
	ShiftCount	equ	2
else
	ShiftCount	equ	1
endif

	.CONST

LOGO		byte	"STARTUP1/2 ASM Demonstration Program", CR, LF,
			"Copyright (c) 1995, MoonWare", CR, LF, LF,
			"The memory model is ", NULL
szARGADDRESSING byte	"ARGC/ARGV[] addressing is ", NULL

Ifdef SIMPLE
szADDRTYPE	byte	"SIMPLE", NULL
else
szADDRTYPE	byte	"NORMAL", NULL
endif

szDGRP		byte	"The value of DGroup is: 0x", NULL
szPSP		byte	"The value of PSP is: 0x", NULL
szSTACK_BOTTOM	byte	"The value of STACK_BOTTOM is: 0x", NULL
szENVIRON	byte	"The value of ENVIRON is: 0x", NULL
szENV_STR_LEN	byte	"The length of ENVIRON is: ", NULL
szOSMAJOR	byte	"The OS major value is: ", NULL
szOSMINOR	byte	"The OS minor value is: ", NULL
szNEXTPARA	byte	"The value for the next memory paragraph is: 0x", NULL
if	@Model	EQ 1
szMEMMODEL	byte	"Tiny.", NULL
elseif	@Model	EQ 2
szMEMMODEL	byte	"Small.", NULL
elseif	@Model	EQ 3
szMEMMODEL	byte	"Compact.", NULL
elseif	@Model	EQ 4
szMEMMODEL	byte	"Medium.", NULL
elseif	@Model	EQ 5
szMEMMODEL	byte	"Large.", NULL
elseif	@Model	EQ 6
szMEMMODEL	byte	"Huge.", NULL
endif
szARGCOUNT	byte	"The value of argc is: ", NULL
szARGV		byte	"The argv[] strings are: ", NULL
szNONE		byte	"None", NULL

	.DATA?

szTEMP		byte	6 dup (?)

;=========================================================================
;	CODE
;=========================================================================
; F	Start the Start_Up code.  Start CODE segment with the proper
;	relationship with external procedures.
;
;	Change the 1 to 2 for testing START_UP2

ifdef SIMPLE
Start_Up2	equ	<Start_Up2S>
endif

if @CodeSize
extrn	Start_Up2:FAR
.CODE
else
.CODE
extrn	Start_Up2:NEAR
endif

;----------------------------
; G	Select the proper arguments for the startup code.  The order is
;	different for SIMPLE than NORMAL.

ifdef	SIMPLE
Main	proc	ARGV:ptr, ARGC:word
else
Main	proc	ARGC:word, ARGV:ptr
endif

local	COUNT:word

;----------------------------
; H	Call Stack Check if DEBUG is defined.

ifdef	DEBUG
	call	Stack_Check
endif

;----------------------------
; I	Display LOGO

	mov	dx, offset LOGO
	call	Print

;----------------------------
; J	Display Memory model

	mov	dx, offset szMEMMODEL
	call	Puts

;----------------------------
; K	Display ARGC/ARGV[] addressing type

	mov	dx, offset szARGADDRESSING
	call	Print
	mov	dx, offset szADDRTYPE
	call	Puts

;----------------------------
; L	Display the DGROUP segment value

	mov	dx, offset szDGRP
	call	Print
	mov	di, offset szTEMP
	mov	dx, DGRP
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; M	Display the PSP segment value

	mov	dx, offset szPSP
	call	Print
	mov	di, offset szTEMP
	mov	dx, PSP
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; N	Display the NEXTPARA segment value

	mov	dx, offset szNEXTPARA
	call	Print
	mov	di, offset szTEMP
	mov	dx, NEXTPARA
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; O	Display the STACK_BOTTOM value

	mov	dx, offset szSTACK_BOTTOM
	call	Print
	mov	di, offset szTEMP
	mov	dx, STACK_BOTTOM
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; P	Display the ENVIRON segment value

	mov	dx, offset szENVIRON
	call	Print
	mov	di, offset szTEMP
	mov	dx, ENVIRON
	call	Bin2Hex
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; Q	Display the OSMAJOR value

	mov	dx, offset szOSMAJOR
	call	Print
	mov	al, OSMAJOR
	xor	ah, ah
	mov	di, offset szTEMP
	call	Utoa
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; P	Display the OSMINOR value

	mov	dx, offset szOSMINOR
	call	Print
	mov	al, OSMINOR
	xor	ah, ah
	mov	di, offset szTEMP
	call	Utoa
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; Q	Display the number of command line arguments

	mov	dx, offset szARGCOUNT
	call	Print
	mov	ax, ARGC
	mov	di, offset szTEMP
	call	Utoa
	mov	dx, offset szTEMP
	call	Puts

;----------------------------
; R	Display the Command Line argument lead in line.  If none, skip.

	or	ARGC, 0 			; Is ARGC == 0?
	je	MN3
	mov	dx, offset szARGV
	call	Puts

;----------------------------
; S	Display all the command line arguments, one to a line.

	mov	COUNT, 0		; Initialize COUNT
MN1:	mov	ax, COUNT		; AX = COUNT, source
	mov	di, offset szTEMP	; DI => szTEMP, target
	call	Utoa			; Convert to ASCIIZ string

;---------------------------
; T	Convert the format of string to xx:(null).  If there is only one
;	digit, move it over one.

	mov	si, offset szTEMP	; SI => szTEMP
	cmp	byte ptr [si + 1], 0	; Is the 2nd char null?
	jne	MN2			; No, skip special case

;---------------------------
; U	The format is x(null).	Convert to bx where b is a blank.

	mov	al, [si]		; AL = char
	mov	[si + 1], al		; Move complete
	mov	byte ptr [si], ' '	; Blank first char

;---------------------------
; V	Add colon, space and null terminator

MN2:	mov	word ptr [si + 2], ' :' ; Add the ': '
	mov	byte ptr [si + 4], 0	; Null terminate

;----------------------------
; W	Display the leader

	mov	dx, si
	call	Print

;----------------------------
; X	Display the corresponding *argv[].  Must be done two ways.  First,
;	for the Normal, then for the Simple.
;
;	For the Normal, it really is argv.

	mov	di, COUNT		; BX = COUNT
	shl	di, ShiftCount		; Convert to word/dword pointer
ifndef	SIMPLE
	@LES	bx, ARGV		; BX => ARGV[]
	mov	dx, [di][bx]		; DX => *ARGV[count]
else
	@LES	dx, ARGV[di]
endif
	call	Puts			; Display it
if @DataSize
	mov	es, DGRP		; Restore ES
endif

;----------------------------
; Y	See if we are complete.

	inc	COUNT			; Increment COUNT
	mov	ax, COUNT		; AX = COUNT
	cmp	ax, ARGC		; Is AX < ARGC
	jl	MN1			; Yes, continue

;----------------------------
; Z	Return with 0 return code.

MN3:	xor	al, al
	ret

Main	endp
	end
