	page 60,132
	title Start_Up1 -- Intermediate Start Up Code for .COM/.EXE Programs
	name Start_Up1

comment 
        Start_Up1                                               V1.06
--------------------------------------------------------------------------
NAME
	startup1	Intermediate start up code for .com and .exe
			programs

SYNOPSIS
	extern Start_Up1
	or
	extern Start_Up1S

	See Programming Notes below for difference.

DESCRIPTION
	This is the startup code for all .exe and .com assembly language
	programs.  Just use the SYNOPSIS above in the main function to
	include this startup code in the .exe file from a .lib.	For .com
	assembly language programs, this source code must be the first
	assembled so that this code is the linked first.

	This procedure parses the command line into argc and *argv[] similar
	to C.  Argv[0] is the first command line argument not the program
	name as in C.
	
	This procedure performs the following functions in addition to above
	- Initializes the following global variables:
	  -- DGRP, segment address of DGROUP
	  -- STACK_BOTTOM, offset to stack bottom in DGROUP
	  -- PSP, segment address of PSP
	  -- ENVIRON, segment address of passed copy of the ENVIRONMENT
	  -- OSMAJOR, integer part of OS system
	  -- OSMINOR, decimal part of OS system
	- If DOS version is less than 2.0, aborts with error message
	- Initializes DS and ES segment registers to DGROUP
	- Shrinks memory down to size of program by releasing all memory 
	  above program

RETURNS
	If main returns to startup code.  The program terminiates with the 
	return code in AL.

PROGRAMING NOTES
	Assembled with Microsoft MASM V6.11d with options: /Cp /W3 /Wx
	/memmod={see below}.  Do not use the /NOI switch with linker.

	Written to link with any memory model.
	
	Use MEMMOD to specify the memory model.
	/dMEMMOD=TINY|SMALL|COMPACT|MEDIUM|LARGE|HUGE

	Written using the FORTRAN/PASCAL/BASIC calling convention so passed
	parameters are pushed in the order of appearance in the proc 
	declaration.

	This procedure can pass argc and argv on stack two ways.   The proc
	declaration in the MAIN procedure will differ depending upon the 
	choice.
	
	The default requires the following proc declaration:
	
		MAIN proc ARGC:word, ARGV:ptr
	
	If SIMPLE is defined, an alternate proc declaration is required:
	
		MAIN proc ARGV:ptr, ARGC:word
	
	Here, ARGV is not a pointer to an array of pointers but the location
	of the 1st pointer.

	In Huge memory model, the pointers passed in ARGV are long pointer
	vice huge pointers.

MEMORY REQUIREMENTS
	(in bytes)     Tiny   Small   Medium   Compact	Large	Huge
	Code:		165    190	192	 193	 195	195
	Code (SIMPLE):	162    187	189	 189	 191	191
	_Data:		  0	 0	  0	   0	   0	  0
	Const:		  0	 0	  0	   0	   0	  0
	_BBS:		 12	12	 12	  12	  12	 12
	Stack:		  ?	 ?	  ?	   ?	   ?	  ?

	The first code size is for SIMPLE not defined.	The Code (SIMPLE) is
	for when SIMPLE is defined.

	Stack usage is determined by the size of and the number of arguments
	in the command line.

	Note:  The 12 bytes in _BSS are from sudata.asm which is used so that
	all startup code can reside in the same .lib file.

CAUTION
	Startup1 defines a 512 byte stack.  This should be enough for programs
	who make moderate use of the stack.  If automatic variables are used
	extensively, more stack space should be defined in the main module
	unless using the tiny memory model.  In this case, the startup code
	must be the first souce file in the build, change the size of the
	STACK_SIZE define.
	
	Linker option, NO IGNORE CASE, is not used so that the linker will
	handle __end properly.
	
EXTERNAL LIBRARIES
	sudata		alib?

EXTERNAL PROCEDURES
	main		user defined

INTERUPTS CALLED
	Int 21h 30h - Get Version Number
	Int 21h 4ah - Set Memory Block Size
	Int 21h 4ch - Terminate program with return code

GLOBAL NAMES
	Startup_1 or Startup_1S

AUTHOR
	Raymond Moon - 7 Sep 87

        Copyright (c) 1987, 1988, 1994, 1995, 1996 - MoonWare
	ALL RIGHTS RESERVED

VERSION
	Version	- Date		- Remarks
	1.00	-  7 Sep 87	- Original
        1.01    - 13 Feb 88     - Updated program to parse command line
				- This created Startup1 from Startup0
	1.02	-  4 Jul 88	- Converted to MASM V5.1
	1.03	-  9 Oct 88	- Added Stack_Bottom & ZZ_PRGM_TOP segment
				  to determine end of data.
	1.04	- 30 Oct 94	- Moved ZZ_PRGM_TOP segment position in file.
				- Removed increment in program size in paras
				    as ZZ_PRGM_TOP is aligned on a para.
	1.05	-  5 Mar 95	- Added TINY Model capability
				- Converted to .dosseg using __end vice
				  ZZ_PRGM_TOP for end of data
				- Removed checking for DOS Ver 1.0 and
                                  terminating with error message.
        1.06    - 29 Dec 96     - Optimized the .com coding
==========================================================================
	  Commend End

;-----------------------------
; A      Make the small memory model the default

ifndef	memmod
memmod	equ	<small>
endif

;-----------------------------
; B	Include the processor, memory model, associate ES register with
;	DGROUP, and specify DOS segment order.

	include procesor.inc
%	.MODEL	memmod,FORTRAN
	assume	es:DGROUP
	.dosseg

;----------------------------
; C     Required includes

	include startup.inc

;----------------------------
; D     Define any required equates

STACK_SIZE	equ	512

;=========================================================================
;	DATA
;=========================================================================
; E     Define storage for the various global and system variables.

if	@Model	NE  1
	.STACK	STACK_SIZE	; Define a nominal stack
endif

;----------------------------
; F     Define __end which is defined when using .dosseg

externdef	__end:byte

;----------------------------
; G     Define segment for addressing information in the PSP

PSP_SEG	segment at 00h
	
	org	2h
NEXTPARA_PTR	dw	?		; Segment address of next memory para

	org	2ch
ENVIRON_PTR	dw	?		; Segment address of Environment

	org     80h
PARM_LEN 	db	?		; Number of bytes in Command Line tail
PARMS   	db	127 dup(?)	; Start of Command Line tail
PSP_SEG	ends

;=========================================================================
;	CODE
;=========================================================================
; H     Put the called main procedure in the proper relationship to the
;	startup code.

if @CodeSize
extrn	Main:far
.CODE
else
.CODE
extrn	Main:near
endif

;-----------------------------
; I     Include org statement if tiny model

if	@Model	EQ 1

	org	100h
endif

;-----------------------------
; J     Start the Start_Up1 code.  Make it a far procedure so error return
;	will work.  If SIMPLE is defined, redefined Start_Up1 as Start_Up1S.

ifdef SIMPLE
Start_Up1	equ	<Start_Up1S>
endif

% Start_Up1	proc	far

;-----------------------------
; K     First, initialize global variables.  Set DS to DGROUP.
;	Skip DGROUP code for .com(Tiny) memory models

if	@Model	NE 1

	mov	ax, DGROUP		; Get seg address of DGROUP
	mov	ds, ax			; Initialize DS segment register
	mov	DGRP, ax		; Initialize DGRP
assume	es:PSP_SEG
else
	mov	DGRP, ds		; Initialize DGRP
endif
	mov	PSP, es			; Initialize PSP
if	@Model	eq 1
assume	ds:PSP_SEG
endif
	mov	bx, ENVIRON_PTR 	; Get segment address of environment
	mov	cx, NEXTPARA_PTR	; Get segment address of next memory
if	@Model	eq 1
assume	ds:DGROUP
endif
	mov	ENVIRON, bx		; Initialize ENVIRON
	mov	NEXTPARA, cx		; Initialize NEXTPARA
	mov	ah, 30h			; Get DOS version number
	int	21h			; Call DOS
	mov	OSMAJOR, al		; Save major version number
	mov	OSMINOR, ah		; Save minor version number

;----------------------------
; L     Combine the stack into DGROUP so that it is addressable from DGROUP.
;	Initialize STACK_BOTTOM.

	lea	bx, __end		; Get pointer to end of data

if	@Model	eq	1		; Ensure that Stack bottom at paragraph
        add     bx, 15                  ; Add to ensure next para if necessary
        and     bx, 0fff0h              ; Truncate to a paragraph boundary
endif

	mov	STACK_BOTTOM, bx	; Save it

if	@Model	eq	1		; Get stack size
	add	bx, STACK_SIZE		; DI = stack size
else
	add	bx, sp			; DI = stack size
endif

	mov	dx, ds			; Get DGROUP segment address
	mov	ss, dx			; Reset SS
	mov	sp, bx			; Reset SP

;----------------------------
; M     Release all memory above program.  Calculate the size of the program
;	in paragraphs (16 bits).  BX starts with Stack Top

	mov	cl, 4			; Convert to #para by dividing by 16
	shr	bx, cl			; Do division by bit shifting

if	@Model	ne	1		; Needed in non-Tiny memory models
	mov	ax, ds			; AX => DGROUP
	sub	ax, PSP			; AX = # para for code
	add	bx, ax			; BX = # para in program
endif

	mov	ah, 4ah			; Request DOS set block
	int	21h			; Call DOS

;----------------------------
; N     See if there are any command line arguments.  If not, all command
;	line processing is skipped.  The pushed null on the stack will be
;	argc, and a null pointer is also pushed onto the stack so argv[0]
;	is a null pointer.

	xor	dx, dx			; Ensure DX is null
	push	dx			; Ensure null on top of stack
	mov	bp, sp			; BP = top of stack
if @Model NE 1
	cmp	es:PARM_LEN, 0		; Are there any Command Line arguments
else
assume	ds:PSP_SEG
	cmp	PARM_LEN, 0		; Are there any Command Line arguments
assume	ds:DGROUP
endif
	jne	SU1			; No, go process what is on the stack
	push	dx			; Push null pointer
if @DataSize
	push	dx			; Make a doubleword null pointer
endif
if @Model NE 1
	mov	es, DGRP		; Initialize ES for all except tiny
endif
	jmp	short SU7		; Go call MAIN

;----------------------------
; O     There are command line arguments.  Parse them onto the stack and 
;	build ARGC and ARGV.  Start this by transferring the entire command
;	line tail onto the stack.  Make room for them by moving SP.

SU1:
if @Model NE 1
	mov	ds, PSP			; DS => PSP
endif
assume ds:PSP_SEG
	mov	cl, PARM_LEN		; Get # of bytes in Command Line
	inc	cx			; increase by one
	and	cx, 0feh		; Force an even count
	mov	ax, sp			; Get SP
	sub	ax, cx			; Subtract PARM_LEN
	mov	sp, ax			; Reset SP, room on Stack
	lea	si, PARMS		; Load source addr in SI
	mov	di, sp			; Load destin addr in DI
if @Model NE 1
	mov	es, DGRP		; ES => DGROUP
endif
assume	es:DGROUP
	rep	movsb			; Move Command Line onto the Stack
if @Model NE 1
	mov	ds, es:DGRP		; Restore DS
endif
assume	ds:DGROUP
	
;-----------------------------
; P     Convert all blanks, not within double quotes, in the Command Line
;	to Nul.  CX is IN_LITERAL_FLAG.  Build argv[] at the same time.

	xor	di, di			; DI set to zero, DI = arg count
	mov	bx, bp			; BX points to last byte in stack
	mov	bp, sp			; BP is the stop point
	xor	cx, cx			; Clear IN_LITERAL_FLAG
SU2:	mov	al, [bx]		; Get byte
	cmp	al, '"'			; Is it a literal?
	jne	SU3			; No, go to next test
	inc	cx			; Set IN_LITERAL_FLAG
	and	cx, 1			; Ensure only 0, & 1 valid
	jmp	short SU4		; Continue, and blank '"'
SU3:	cmp	al, ' '			; Is it a blank?
	ja	SU6			; No, go set up to get another
	or	cx, cx			; Is IN_LITERAL_FLAG clear?
	jne	SU6			; No, do not null blank
SU4:	mov	byte ptr [bx], 0	; Store Nul in [BX]
SU5:	or	byte ptr [bx + 1], 0	; Was the previous char null?
	jz	SU6			; Yes, do not push pointer
if @datasize
	push	ss			; Push segment address
endif
	mov	ax, bx			; AX => Null
	inc	ax			; AX => 1st char
	push	ax			; Push the offset
	xor	cx, cx			; Clear in literal flag
	inc	di			; Account for another arg
SU6:	dec	bx			; BX point to next byte
	cmp	bx, bp			; Are we through yet?
	jnb	SU2			; No, go one mo' 'gin

;-----------------------------
; Q     Have finished building *argv[]. SP => argv[], and DI = argc.
;	Create argc and argv on the stack using the FORTRAN calling
;	convention.  If SIMPLE is defined, push only argc.  See documentation
;	above for structure of proc declaration in MAIN procedure

ifndef SIMPLE
	mov	bx, sp			; BX = **argv[]
	push	di			; Push argc
if @DataSize
	push	ss			; Long pointer
endif
	push	bx			; Push **argv[]
else
	push	di			; Push argc
endif
	
;-----------------------------
; R     call MAIN

SU7:	call	Main			; Call MAIN procedure

;----------------------------
; S     If main returns, the program is to terminate with the return code
;	returned in AL

	mov	ah, 4ch			; End process
	int	21h			; Call DOS

% Start_Up1	endp

%	end	Start_Up1		; Indicate that Start_Up1 is the start
					; of the program
