_if            equ     0
_else          equ     1
_case          equ     2
_when          equ     3
_otherwise     equ     4
_loop          equ     5
_repeat        equ     6
_do            equ     7
_while         equ     8
_package       equ     9
_procedure     equ     10
_task          equ     11
_begin         equ     12
_exit          equ     13
_declare       equ     14
_table         equ     15
_byte          equ     1
_int           equ     2
_dint          equ     4
_byte_type     equ     BYTE
_int_type      equ     WORD
_dint_type     equ     DWORD
ZERO            equ     0
NOT_ZERO        equ     NOT(ZERO)
CARRY           equ     1
NO_CARRY        equ     2
PLUS            equ     3
MINUS           equ     4
PARITY_EVEN     equ     5
PARITY_ODD      equ     6
ABOVE           equ     7
ABOVE_OR_EQUAL  equ     8
BELOW_OR_EQUAL  equ     9
BELOW           equ     10
GREATER_THAN    equ     11
GREATER_OR_EQUAL        equ     12
LESS_OR_EQUAL   equ     13
LESS_THAN       equ     14
_JMP           equ     15
_JNE           equ     16
OVERFLOW        equ     17
NO_OVERFLOW     equ     18
EQUAL           equ     ZERO
NOT_EQUAL       equ     NOT_ZERO
FALSE           equ     ZERO
TRUE            equ     NOT_ZERO
_IFCNT          =       0
_CASECNT        =       0
_WHENCNT        =       0
_LOOPCNT        =       0
_REPEATCNT      =       0
_DOCNT          =       0
_PROCCNT        =       0
_TASKCNT        =       0
_BEGINCNT       =       0
_PACKCNT        =       0
_CURIF          =       0
_CURCASE        =       0
_CURLOOP        =       0
_CURREPEAT      =       0
_CURDO          =       0
_VAR_OFFSET     =       0
_SP             =       0


_MAKEJP         MACRO
        ##IF (#1 EQ _JMP)
           JMP #2
           #EX
        ##ENDIF
        ##IF (#1 EQ _JNE)
           JNE #2
           #EX
        ##ENDIF
        ##IF (#1 EQ ZERO)
           JNZ #2
           #EX
        ##ENDIF
        ##IF (#1 EQ NOT_ZERO)
           JZ #2
           #EX
        ##ENDIF
        ##IF (#1 EQ CARRY)
           JNC #2
           #EX
        ##ENDIF
        ##IF (#1 EQ NO_CARRY)
           JC #2
           #EX
        ##ENDIF
        ##IF (#1 EQ PLUS)
           JS #2
           #EX
        ##ENDIF
        ##IF (#1 EQ MINUS)
           JNS #2
           #EX
        ##ENDIF
        ##IF (#1 EQ PARITY_EVEN)
           JPO #2
           #EX
        ##ENDIF
        ##IF (#1 EQ PARITY_ODD)
           JPE #2
           #EX
        ##ENDIF
        ##IF (#1 EQ OVERFLOW)
           JNO #2
           #EX
        ##ENDIF
        ##IF (#1 EQ NO_OVERFLOW)
           JO #2
           #EX
        ##ENDIF
        ##IF (#1 EQ ABOVE)
           JNA #2
           #EX
        ##ENDIF
        ##IF (#1 EQ ABOVE_OR_EQUAL)
           JNAE #2
           #EX
        ##ENDIF
        ##IF (#1 EQ BELOW_OR_EQUAL)
           JNBE #2
           #EX
        ##ENDIF
        ##IF (#1 EQ BELOW)
           JNB #2
           #EX
        ##ENDIF
        ##IF (#1 EQ GREATER_THAN)
           JNG #2
           #EX
        ##ENDIF
        ##IF (#1 EQ GREATER_OR_EQUAL)
           JNGE #2
           #EX
        ##ENDIF
        ##IF (#1 EQ LESS_OR_EQUAL)
           JNLE #2
           #EX
        ##ENDIF
        ##IF (#1 EQ LESS_THAN)
           JNL #2
           #EX
        ##ENDIF
        #EM


_GENLAB         MACRO
#1#V2:
        #EM


_GENINST        MACRO
                _MAKEJP #1,#2#V3
        #EM


_GENWLAB        MACRO
_WHEN#V1_#V2:
        #EM


_GENCLAB        MACRO
_CASE#V1:
        #EM



_GENWINST       MACRO
        _MAKEJP #1,_WHEN#V2_#V3
        #EM


_STORE          MACRO
#1#V2           =      #3
        #EM


_LOAD           MACRO
#1              =      #2#V3
        #EM


_PUSH           MACRO
_SP             =       _SP + 1
        _STORE _STACK,_SP,#1
        #EM

_POP            MACRO
        ##IF (_SP EQ 0)
        #EX
        ##ENDIF
        _LOAD #1,_STACK,_SP
_SP             =       _SP - 1
        #EM


IF_             MACRO
        _PUSH   _CURIF
_IFCNT          =       _IFCNT + 1
_CURIF          =       _IFCNT
        _GENLAB    _IF,_IFCNT
        _GENINST   #1,_ELSE,_IFCNT
        _PUSH   _IFCNT
        _PUSH   _IF
        #EM


ELSE_           MACRO
        _POP    _TYPE
        _POP    _COUNT
        ##IF (_TYPE NE _IF)
        #EX
        ##ENDIF
        _GENINST    _JMP,_ENDIF,_COUNT
        _GENLAB     _ELSE,_COUNT
        _PUSH       _COUNT
        _PUSH       _ELSE
        #EM


ENDIF_          MACRO
        _POP      _TYPE
        _POP      _COUNT
        ##IF ((_TYPE NE _IF) AND (_TYPE NE _ELSE))
        #EX
        ##ENDIF
        ##IF (_TYPE EQ _IF)
                _GENLAB _ELSE,_COUNT
        ##ENDIF
        _GENLAB _ENDIF,_COUNT
        _POP    _CURIF
        #EM


CASE_           MACRO
        _PUSH   _CURCASE

_CASECNT        =       _CASECNT + 1
_CURCASE        =       _CASECNT

        _GENCLAB   _CURCASE
        NOP
        ##IF  (#S1 NE 0)
        MOV   AX,#V1
        ##ENDIF
        _PUSH   0
        _PUSH   _CASECNT
        _PUSH _CASE
        #EM


WHEN_           MACRO
        _POP    _TYPE
        _POP    _COUNT
        _POP    _WHENCNT
        ##IF (_TYPE NE _CASE) AND (_TYPE NE _WHEN)
        #EX
        ##ENDIF
        ##IF (_WHENCNT GT 0)
                _GENINST _JMP,_ENDCASE,_COUNT
        ##ENDIF
        _GENWLAB _COUNT,_WHENCNT
        CMP  AX,#1
        _GENWINST  _JNE,_COUNT,(_WHENCNT + 1)
        _PUSH    (_WHENCNT + 1)
        _PUSH    _COUNT
        _PUSH    _WHEN
        #EM



OTHERWISE_      MACRO
        _POP    _TYPE
        _POP    _COUNT
        _POP    _WHENCNT
        ##IF (_TYPE NE _WHEN)
        #EX
        ##ENDIF
        _GENINST        _JMP,_ENDCASE,_COUNT
        _GENWLAB        _COUNT,_WHENCNT
        _PUSH    _WHENCNT
        _PUSH    _COUNT
        _PUSH    _OTHERWISE
        #EM


ENDCASE_        MACRO
        _POP    _TYPE
        _POP    _COUNT
        _POP    _WHENCNT
        ##IF (_TYPE NE _WHEN) AND (_TYPE NE _OTHERWISE)
        #EX
        ##ENDIF
        ##IF (_TYPE EQ _WHEN)
                _GENWLAB _COUNT,_WHENCNT
        ##ENDIF
        _GENLAB  _ENDCASE,_COUNT
        _POP   _CURCASE
        #EM


LOOP_           MACRO
        _PUSH  _CURLOOP
_LOOPCNT        =       _LOOPCNT + 1
_CURLOOP        =       _LOOPCNT
        _GENLAB   _LOOP,_LOOPCNT
        _PUSH    _LOOPCNT
        _PUSH    _LOOP
        #EM


ENDLOOP_        MACRO
        _POP    _TYPE
        _POP    _COUNT
        ##IF (_TYPE NE _LOOP)
        #EX
        ##ENDIF
        _GENINST        _JMP,_LOOP,_COUNT
        _GENLAB         _ENDLOOP,_COUNT
        _POP    _CURLOOP
        #EM



REPEAT_         MACRO
        _PUSH   _CURREPEAT
_REPEATCNT      =       _REPEATCNT + 1
_CURREPEAT      =       _REPEATCNT
        _GENLAB _REPEAT,_REPEATCNT
        _PUSH  _REPEATCNT
        _PUSH  _REPEAT
        #EM


UNTIL_          MACRO
        _POP   _TYPE
        _POP   _COUNT
        ##IF (_TYPE NE _REPEAT)
        #EX
        ##ENDIF
        _GENINST  #1,_REPEAT,_COUNT
        _GENLAB   _ENDREPEAT,_COUNT
        _POP    _CURREPEAT
        #EM


DO_             MACRO
        _PUSH   _CURDO
_DOCNT          =       _DOCNT + 1
_CURDO          =       _DOCNT
        _GENLAB _DO,_DOCNT
        _PUSH   _DOCNT
        _PUSH   _DO
        #EM


WHILE_          MACRO
        _POP    _TYPE
        _POP    _COUNT
        ##IF (_TYPE NE _DO)
        #EX
        ##ENDIF
        _GENINST   #1,_ENDDO,_COUNT
        _PUSH   _COUNT
        _PUSH   _WHILE
        #EM


ENDDO_          MACRO
        _POP    _TYPE
        _POP    _COUNT
        ##IF (_TYPE NE _WHILE)
        #EX
        ##ENDIF
        _GENINST   _JMP,_DO,_COUNT
        _GENLAB    _ENDDO,_COUNT
        _POP       _CURDO
        #EM


PROCEDURE_      MACRO
        ##IF (_SP NE ZERO)
        #EX
_SP             =       0
        ##ENDIF
_PROCCNT        =       _PROCCNT + 1
#1      PROC    #2
        #EM


ENDPROCEDURE_   MACRO
        ##IF (_SP NE 0)
        NOP
_SP             =       0
        ##ENDIF
        _GENLAB _ENDPROC,_PROCCNT
        ##IF (_VAR_OFFSET GT 0)
        _RELEASE _VAR_OFFSET
_VAR_OFFSET     =       0
        ##ENDIF
        RET     #2
#1      ENDP
        #EM


TASK_   MACRO
        ##IF (_SP NE 0)
        NOP
_SP             =       0
        ##ENDIF
_TASKCNT        =       _TASKCNT + 1
#1      PROC    #2
        #EM


ENDTASK_        MACRO
        ##IF (_SP NE 0)
        NOP
_SP             =       0
        ##ENDIF
        _GENLAB _ENDTASK,_TASKCNT
        ##IF (_VAR_OFFSET GT 0)
        _RELEASE _VAR_OFFSET
_VAR_OFFSET     =       0
        ##ENDIF
        ##IF (#S3 NE 0)
                #3
        ##ELSE
        RET  #2
        ##ENDIF
#1      ENDP
        #EM


BEGIN_          MACRO
_BEGINCNT       =       _BEGINCNT + 1
        _GENLAB _BEGIN_#1,_BEGINCNT
        _PUSH   _BEGINCNT
        _PUSH   _BEGIN
        #EM


ENDBEGIN_       MACRO
        _POP    _TYPE
        _POP    _COUNT
        ##IF (_TYPE NE _BEGIN)
        #EX
        ##ENDIF
        _GENLAB _ENDBEG_#1,_COUNT
        #EM


PACKAGE_        MACRO
#1:
        #EM


ENDPACKAGE_     MACRO
_END_#1:
        #EM


EXIT_           MACRO
        ##IF !   #1_
        NOP
        #EX
        ##ELSEIF (_#1 EQ _BEGIN)
                _GENINST _JMP,_ENDBEG_#2,_COUNT
        #EX
        ##ELSEIF (_#1 EQ _IF)
                _GENINST _JMP,_ENDIF,_CURIF
        #EX
        ##ELSEIF (_#1 EQ _CASE)
                _GENINST _JMP,_ENDCASE,_CURCASE
        #EX
        ##ELSEIF (_#1 EQ _LOOP)
                _GENINST _JMP,_ENDLOOP,_CURLOOP
        #EX
        ##ELSEIF (_#1 EQ _REPEAT)
                _GENINST _JMP,_ENDREPEAT,_CURREPEAT
        #EX
        ##ELSEIF (_#1 EQ _WHILE)
                _GENINST _JMP,_ENDDO,_CURDO
        #EX
        ##ELSEIF (_#1 EQ _PROCEDURE)
                _GENINST _JMP,_ENDPROC,_PROCCNT
        #EX
                _GENINST _JMP,_ENDTASK,_TASKCNT
        #EX
        ##ELSE
        NOP
        #EX
        ##ENDIF
        ##ENDIF
        ##ENDIF
        ##ENDIF
        ##ENDIF
        ##ENDIF
        ##ENDIF
        ##ENDIF
        #EM


CONST_  MACRO
#1      EQU     #2
        #EM


DATA_   MACRO
        ##IF (_#1 EQ _BYTE)
        DB      #2
        #EX
        ##ELSEIF (_#1 EQ _INT)
        DW      #2
        #EX
        ##ELSEIF (_#1 EQ _DINT)
        DD      #2
        #EX
        ##ELSE
        NOP
        #EX
        ##ENDIF
        ##ENDIF
        ##ENDIF
        #EM


VAR_    MACRO
        ##IF (_#2 EQ _BYTE) OR (_#2 EQ _INT) OR (_#2 EQ _DINT)
                ##IF (_SP EQ 0)
#1      LABEL   _#2_TYPE
        DATA    #2,?
        #EX
        ##ELSE
        _POP    _TYPE
        ##IF (_TYPE NE _DECLARE)
        NOP
        ##ENDIF
_VAR_OFFSET             =       _VAR_OFFSET - _#1
#1                      =       _VAR_OFFSET
        _PUSH   _TYPE
        #EX
        ##ENDIF
        ##ELSE
        NOP
        ##ENDIF
        #EM


ARRAY_  MACRO
        ##IF (_#2 EQ _BYTE) OR (_#2 EQ _INT) OR (_#2 EQ _DINT)
        ##IF (_SP EQ 0)
                LABEL _#2_TYPE
                DATA_  #2,#3' DUP (?)'
                #EX
        ##ELSE
        _POP    _TYPE
        ##IF (_TYPE NE _DECLARE)
        NOP
        ##ENDIF
_VAR_OFFSET             =       _VAR_OFFSET - (_#2 * #3)
#1              =       _VAR_OFFSET
        _PUSH   _TYPE
        #EX
        ##ENDIF
        ##ELSE
        NOP
        ##ENDIF
        #EM


TABLE_  MACRO
        ##IF #S2 = 0
#1      LABEL   BYTE
        ##ELSEIF (_#2 EQ _BYTE) OR (_#2 EQ _INT) OR (_#2 EQ _DINT)
#1      LABEL   _#2_TYPE
        ##ELSE
        NOP
        ##ENDIF
        ##ENDIF
        #EM


ENDTABLE_       MACRO
_#1     LABEL   BYTE
        #EM


DECLARE_        MACRO
        _PUSH   _DECLARE
        #EM


ENDDECLARE_     MACRO
        _POP _TYPE
        ##IF (_TYPE NE _DECLARE)
        NOP
        ##ENDIF
        ##IF (_VAR_OFFSET NE 0)
        _ALLOCATE  _VAR_OFFSET
        #EX
        ##ELSE
        NOP
        ##ENDIF
        #EM


_ALLOCATE       MACRO
        PUSH BP
        MOV BP,SP
        ADD SP,#1
        #EM


_RELEASE        MACRO
        MOV SP,BP
        POP BP
        #EM
